/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.FleetScalingType;
import software.amazon.awssdk.services.codebuild.model.TargetTrackingScalingConfiguration;
import software.amazon.awssdk.services.codebuild.model.TargetTrackingScalingConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingConfigurationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingConfigurationOutput> {
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scalingType").getter(ScalingConfigurationOutput.getter(ScalingConfigurationOutput::scalingTypeAsString)).setter(ScalingConfigurationOutput.setter(Builder::scalingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingType").build()}).build();
    private static final SdkField<List<TargetTrackingScalingConfiguration>> TARGET_TRACKING_SCALING_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetTrackingScalingConfigs").getter(ScalingConfigurationOutput.getter(ScalingConfigurationOutput::targetTrackingScalingConfigs)).setter(ScalingConfigurationOutput.setter(Builder::targetTrackingScalingConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTrackingScalingConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetTrackingScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCapacity").getter(ScalingConfigurationOutput.getter(ScalingConfigurationOutput::maxCapacity)).setter(ScalingConfigurationOutput.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCapacity").getter(ScalingConfigurationOutput.getter(ScalingConfigurationOutput::desiredCapacity)).setter(ScalingConfigurationOutput.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_TYPE_FIELD, TARGET_TRACKING_SCALING_CONFIGS_FIELD, MAX_CAPACITY_FIELD, DESIRED_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScalingConfigurationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scalingType;
    private final List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs;
    private final Integer maxCapacity;
    private final Integer desiredCapacity;

    private ScalingConfigurationOutput(BuilderImpl builder) {
        this.scalingType = builder.scalingType;
        this.targetTrackingScalingConfigs = builder.targetTrackingScalingConfigs;
        this.maxCapacity = builder.maxCapacity;
        this.desiredCapacity = builder.desiredCapacity;
    }

    public final FleetScalingType scalingType() {
        return FleetScalingType.fromValue(this.scalingType);
    }

    public final String scalingTypeAsString() {
        return this.scalingType;
    }

    public final boolean hasTargetTrackingScalingConfigs() {
        return this.targetTrackingScalingConfigs != null && !(this.targetTrackingScalingConfigs instanceof SdkAutoConstructList);
    }

    public final List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs() {
        return this.targetTrackingScalingConfigs;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetTrackingScalingConfigs() ? this.targetTrackingScalingConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationOutput)) {
            return false;
        }
        ScalingConfigurationOutput other = (ScalingConfigurationOutput)obj;
        return Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString()) && this.hasTargetTrackingScalingConfigs() == other.hasTargetTrackingScalingConfigs() && Objects.equals(this.targetTrackingScalingConfigs(), other.targetTrackingScalingConfigs()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingConfigurationOutput").add("ScalingType", (Object)this.scalingTypeAsString()).add("TargetTrackingScalingConfigs", this.hasTargetTrackingScalingConfigs() ? this.targetTrackingScalingConfigs() : null).add("MaxCapacity", (Object)this.maxCapacity()).add("DesiredCapacity", (Object)this.desiredCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
            case "targetTrackingScalingConfigs": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingScalingConfigs()));
            }
            case "maxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "desiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scalingType", SCALING_TYPE_FIELD);
        map.put("targetTrackingScalingConfigs", TARGET_TRACKING_SCALING_CONFIGS_FIELD);
        map.put("maxCapacity", MAX_CAPACITY_FIELD);
        map.put("desiredCapacity", DESIRED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfigurationOutput, T> g) {
        return obj -> g.apply((ScalingConfigurationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalingType;
        private List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs = DefaultSdkAutoConstructList.getInstance();
        private Integer maxCapacity;
        private Integer desiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfigurationOutput model) {
            this.scalingType(model.scalingType);
            this.targetTrackingScalingConfigs(model.targetTrackingScalingConfigs);
            this.maxCapacity(model.maxCapacity);
            this.desiredCapacity(model.desiredCapacity);
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(FleetScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        public final List<TargetTrackingScalingConfiguration.Builder> getTargetTrackingScalingConfigs() {
            List<TargetTrackingScalingConfiguration.Builder> result = TargetTrackingScalingConfigurationsCopier.copyToBuilder(this.targetTrackingScalingConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetTrackingScalingConfigs(Collection<TargetTrackingScalingConfiguration.BuilderImpl> targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs = TargetTrackingScalingConfigurationsCopier.copyFromBuilder(targetTrackingScalingConfigs);
        }

        @Override
        public final Builder targetTrackingScalingConfigs(Collection<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs = TargetTrackingScalingConfigurationsCopier.copy(targetTrackingScalingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingScalingConfigs(TargetTrackingScalingConfiguration ... targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs(Arrays.asList(targetTrackingScalingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingScalingConfigs(Consumer<TargetTrackingScalingConfiguration.Builder> ... targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs(Stream.of(targetTrackingScalingConfigs).map(c -> (TargetTrackingScalingConfiguration)((TargetTrackingScalingConfiguration.Builder)TargetTrackingScalingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public ScalingConfigurationOutput build() {
            return new ScalingConfigurationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingConfigurationOutput> {
        public Builder scalingType(String var1);

        public Builder scalingType(FleetScalingType var1);

        public Builder targetTrackingScalingConfigs(Collection<TargetTrackingScalingConfiguration> var1);

        public Builder targetTrackingScalingConfigs(TargetTrackingScalingConfiguration ... var1);

        public Builder targetTrackingScalingConfigs(Consumer<TargetTrackingScalingConfiguration.Builder> ... var1);

        public Builder maxCapacity(Integer var1);

        public Builder desiredCapacity(Integer var1);
    }
}

