/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse;

public class ListSharedReportGroupsIterable
implements SdkIterable<ListSharedReportGroupsResponse> {
    private final CodeBuildClient client;
    private final ListSharedReportGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSharedReportGroupsIterable(CodeBuildClient client, ListSharedReportGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSharedReportGroupsResponseFetcher();
    }

    public Iterator<ListSharedReportGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> reportGroups() {
        Function<ListSharedReportGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reportGroups() != null) {
                return response.reportGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSharedReportGroupsResponseFetcher
    implements SyncPageFetcher<ListSharedReportGroupsResponse> {
        private ListSharedReportGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSharedReportGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSharedReportGroupsResponse nextPage(ListSharedReportGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListSharedReportGroupsIterable.this.client.listSharedReportGroups(ListSharedReportGroupsIterable.this.firstRequest);
            }
            return ListSharedReportGroupsIterable.this.client.listSharedReportGroups((ListSharedReportGroupsRequest)((Object)ListSharedReportGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

