/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;
import software.amazon.awssdk.services.codebuild.model.BuildArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.model.BuildPhasesCopier;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.services.codebuild.model.NetworkInterface;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Build
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Build> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::id)).setter(Build.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::arn)).setter(Build.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Build.getter(Build::startTime)).setter(Build.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Build.getter(Build::endTime)).setter(Build.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::currentPhase)).setter(Build.setter(Builder::currentPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()}).build();
    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::buildStatusAsString)).setter(Build.setter(Builder::buildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::sourceVersion)).setter(Build.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<String> RESOLVED_SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::resolvedSourceVersion)).setter(Build.setter(Builder::resolvedSourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedSourceVersion").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::projectName)).setter(Build.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<List<BuildPhase>> PHASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Build.getter(Build::phases)).setter(Build.setter(Builder::phases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildPhase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::source)).setter(Build.setter(Builder::source)).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Build.getter(Build::secondarySources)).setter(Build.setter(Builder::secondarySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Build.getter(Build::secondarySourceVersions)).setter(Build.setter(Builder::secondarySourceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BuildArtifacts> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::artifacts)).setter(Build.setter(Builder::artifacts)).constructor(BuildArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()}).build();
    private static final SdkField<List<BuildArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Build.getter(Build::secondaryArtifacts)).setter(Build.setter(Builder::secondaryArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::cache)).setter(Build.setter(Builder::cache)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()}).build();
    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::environment)).setter(Build.setter(Builder::environment)).constructor(ProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::serviceRole)).setter(Build.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<LogsLocation> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::logs)).setter(Build.setter(Builder::logs)).constructor(LogsLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Build.getter(Build::timeoutInMinutes)).setter(Build.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Build.getter(Build::queuedTimeoutInMinutes)).setter(Build.setter(Builder::queuedTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build()}).build();
    private static final SdkField<Boolean> BUILD_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Build.getter(Build::buildComplete)).setter(Build.setter(Builder::buildComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildComplete").build()}).build();
    private static final SdkField<String> INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::initiator)).setter(Build.setter(Builder::initiator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiator").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::vpcConfig)).setter(Build.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Build.getter(Build::networkInterface)).setter(Build.setter(Builder::networkInterface)).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Build.getter(Build::encryptionKey)).setter(Build.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, CURRENT_PHASE_FIELD, BUILD_STATUS_FIELD, SOURCE_VERSION_FIELD, RESOLVED_SOURCE_VERSION_FIELD, PROJECT_NAME_FIELD, PHASES_FIELD, SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ARTIFACTS_FIELD, SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD, LOGS_FIELD, TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, BUILD_COMPLETE_FIELD, INITIATOR_FIELD, VPC_CONFIG_FIELD, NETWORK_INTERFACE_FIELD, ENCRYPTION_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final String buildStatus;
    private final String sourceVersion;
    private final String resolvedSourceVersion;
    private final String projectName;
    private final List<BuildPhase> phases;
    private final ProjectSource source;
    private final List<ProjectSource> secondarySources;
    private final List<ProjectSourceVersion> secondarySourceVersions;
    private final BuildArtifacts artifacts;
    private final List<BuildArtifacts> secondaryArtifacts;
    private final ProjectCache cache;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final LogsLocation logs;
    private final Integer timeoutInMinutes;
    private final Integer queuedTimeoutInMinutes;
    private final Boolean buildComplete;
    private final String initiator;
    private final VpcConfig vpcConfig;
    private final NetworkInterface networkInterface;
    private final String encryptionKey;

    private Build(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.buildStatus = builder.buildStatus;
        this.sourceVersion = builder.sourceVersion;
        this.resolvedSourceVersion = builder.resolvedSourceVersion;
        this.projectName = builder.projectName;
        this.phases = builder.phases;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.logs = builder.logs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.buildComplete = builder.buildComplete;
        this.initiator = builder.initiator;
        this.vpcConfig = builder.vpcConfig;
        this.networkInterface = builder.networkInterface;
        this.encryptionKey = builder.encryptionKey;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String currentPhase() {
        return this.currentPhase;
    }

    public StatusType buildStatus() {
        return StatusType.fromValue(this.buildStatus);
    }

    public String buildStatusAsString() {
        return this.buildStatus;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public String resolvedSourceVersion() {
        return this.resolvedSourceVersion;
    }

    public String projectName() {
        return this.projectName;
    }

    public List<BuildPhase> phases() {
        return this.phases;
    }

    public ProjectSource source() {
        return this.source;
    }

    public List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public List<ProjectSourceVersion> secondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public BuildArtifacts artifacts() {
        return this.artifacts;
    }

    public List<BuildArtifacts> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public ProjectCache cache() {
        return this.cache;
    }

    public ProjectEnvironment environment() {
        return this.environment;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public LogsLocation logs() {
        return this.logs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Integer queuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public Boolean buildComplete() {
        return this.buildComplete;
    }

    public String initiator() {
        return this.initiator;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public NetworkInterface networkInterface() {
        return this.networkInterface;
    }

    public String encryptionKey() {
        return this.encryptionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPhase());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedSourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.phases());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySources());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySourceVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.cache());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiator());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.currentPhase(), other.currentPhase()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.resolvedSourceVersion(), other.resolvedSourceVersion()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.phases(), other.phases()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.secondarySources(), other.secondarySources()) && Objects.equals(this.secondarySourceVersions(), other.secondarySourceVersions()) && Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(this.cache(), other.cache()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes()) && Objects.equals(this.buildComplete(), other.buildComplete()) && Objects.equals(this.initiator(), other.initiator()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.networkInterface(), other.networkInterface()) && Objects.equals(this.encryptionKey(), other.encryptionKey());
    }

    public String toString() {
        return ToString.builder((String)"Build").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CurrentPhase", (Object)this.currentPhase()).add("BuildStatus", (Object)this.buildStatusAsString()).add("SourceVersion", (Object)this.sourceVersion()).add("ResolvedSourceVersion", (Object)this.resolvedSourceVersion()).add("ProjectName", (Object)this.projectName()).add("Phases", this.phases()).add("Source", (Object)this.source()).add("SecondarySources", this.secondarySources()).add("SecondarySourceVersions", this.secondarySourceVersions()).add("Artifacts", (Object)this.artifacts()).add("SecondaryArtifacts", this.secondaryArtifacts()).add("Cache", (Object)this.cache()).add("Environment", (Object)this.environment()).add("ServiceRole", (Object)this.serviceRole()).add("Logs", (Object)this.logs()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("QueuedTimeoutInMinutes", (Object)this.queuedTimeoutInMinutes()).add("BuildComplete", (Object)this.buildComplete()).add("Initiator", (Object)this.initiator()).add("VpcConfig", (Object)this.vpcConfig()).add("NetworkInterface", (Object)this.networkInterface()).add("EncryptionKey", (Object)this.encryptionKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "currentPhase": {
                return Optional.ofNullable(clazz.cast(this.currentPhase()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "resolvedSourceVersion": {
                return Optional.ofNullable(clazz.cast(this.resolvedSourceVersion()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "phases": {
                return Optional.ofNullable(clazz.cast(this.phases()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "secondarySourceVersions": {
                return Optional.ofNullable(clazz.cast(this.secondarySourceVersions()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
            case "cache": {
                return Optional.ofNullable(clazz.cast(this.cache()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "queuedTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutes()));
            }
            case "buildComplete": {
                return Optional.ofNullable(clazz.cast(this.buildComplete()));
            }
            case "initiator": {
                return Optional.ofNullable(clazz.cast(this.initiator()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "networkInterface": {
                return Optional.ofNullable(clazz.cast(this.networkInterface()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Build, T> g) {
        return obj -> g.apply((Build)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private String buildStatus;
        private String sourceVersion;
        private String resolvedSourceVersion;
        private String projectName;
        private List<BuildPhase> phases = DefaultSdkAutoConstructList.getInstance();
        private ProjectSource source;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();
        private BuildArtifacts artifacts;
        private List<BuildArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ProjectCache cache;
        private ProjectEnvironment environment;
        private String serviceRole;
        private LogsLocation logs;
        private Integer timeoutInMinutes;
        private Integer queuedTimeoutInMinutes;
        private Boolean buildComplete;
        private String initiator;
        private VpcConfig vpcConfig;
        private NetworkInterface networkInterface;
        private String encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.id(model.id);
            this.arn(model.arn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.currentPhase(model.currentPhase);
            this.buildStatus(model.buildStatus);
            this.sourceVersion(model.sourceVersion);
            this.resolvedSourceVersion(model.resolvedSourceVersion);
            this.projectName(model.projectName);
            this.phases(model.phases);
            this.source(model.source);
            this.secondarySources(model.secondarySources);
            this.secondarySourceVersions(model.secondarySourceVersions);
            this.artifacts(model.artifacts);
            this.secondaryArtifacts(model.secondaryArtifacts);
            this.cache(model.cache);
            this.environment(model.environment);
            this.serviceRole(model.serviceRole);
            this.logs(model.logs);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            this.buildComplete(model.buildComplete);
            this.initiator(model.initiator);
            this.vpcConfig(model.vpcConfig);
            this.networkInterface(model.networkInterface);
            this.encryptionKey(model.encryptionKey);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus.toString());
            return this;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final String getResolvedSourceVersion() {
            return this.resolvedSourceVersion;
        }

        @Override
        public final Builder resolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
            return this;
        }

        public final void setResolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<BuildPhase.Builder> getPhases() {
            return this.phases != null ? (Collection)this.phases.stream().map(BuildPhase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phases(Collection<BuildPhase> phases) {
            this.phases = BuildPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(BuildPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<BuildPhase.Builder> ... phases) {
            this.phases(Stream.of(phases).map(c -> (BuildPhase)((BuildPhase.Builder)BuildPhase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhases(Collection<BuildPhase.BuilderImpl> phases) {
            this.phases = BuildPhasesCopier.copyFromBuilder(phases);
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<ProjectSource.Builder> getSecondarySources() {
            return this.secondarySources != null ? (Collection)this.secondarySources.stream().map(ProjectSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        public final Collection<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            return this.secondarySourceVersions != null ? (Collection)this.secondarySourceVersions.stream().map(ProjectSourceVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
            this.secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... secondarySourceVersions) {
            this.secondarySourceVersions(Stream.of(secondarySourceVersions).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        public final BuildArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        @Override
        public final Builder artifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(BuildArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        public final Collection<BuildArtifacts.Builder> getSecondaryArtifacts() {
            return this.secondaryArtifacts != null ? (Collection)this.secondaryArtifacts.stream().map(BuildArtifacts::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = BuildArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(BuildArtifacts ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<BuildArtifacts.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryArtifacts(Collection<BuildArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = BuildArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        public final ProjectCache.Builder getCache() {
            return this.cache != null ? this.cache.toBuilder() : null;
        }

        @Override
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final LogsLocation.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return this.queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        public final Boolean getBuildComplete() {
            return this.buildComplete;
        }

        @Override
        public final Builder buildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
            return this;
        }

        public final void setBuildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
        }

        public final String getInitiator() {
            return this.initiator;
        }

        @Override
        public final Builder initiator(String initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(String initiator) {
            this.initiator = initiator;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return this.networkInterface != null ? this.networkInterface.toBuilder() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public Build build() {
            return new Build(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Build> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(StatusType var1);

        public Builder sourceVersion(String var1);

        public Builder resolvedSourceVersion(String var1);

        public Builder projectName(String var1);

        public Builder phases(Collection<BuildPhase> var1);

        public Builder phases(BuildPhase ... var1);

        public Builder phases(Consumer<BuildPhase.Builder> ... var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourceVersions(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourceVersions(ProjectSourceVersion ... var1);

        public Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder artifacts(BuildArtifacts var1);

        default public Builder artifacts(Consumer<BuildArtifacts.Builder> artifacts) {
            return this.artifacts((BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder secondaryArtifacts(Collection<BuildArtifacts> var1);

        public Builder secondaryArtifacts(BuildArtifacts ... var1);

        public Builder secondaryArtifacts(Consumer<BuildArtifacts.Builder> ... var1);

        public Builder cache(ProjectCache var1);

        default public Builder cache(Consumer<ProjectCache.Builder> cache) {
            return this.cache((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cache)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder serviceRole(String var1);

        public Builder logs(LogsLocation var1);

        default public Builder logs(Consumer<LogsLocation.Builder> logs) {
            return this.logs((LogsLocation)((LogsLocation.Builder)LogsLocation.builder().applyMutation(logs)).build());
        }

        public Builder timeoutInMinutes(Integer var1);

        public Builder queuedTimeoutInMinutes(Integer var1);

        public Builder buildComplete(Boolean var1);

        public Builder initiator(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder networkInterface(NetworkInterface var1);

        default public Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return this.networkInterface((NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation(networkInterface)).build());
        }

        public Builder encryptionKey(String var1);
    }
}

