/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse;
import software.amazon.awssdk.services.codebuild.model.TestCase;

public class DescribeTestCasesPublisher
implements SdkPublisher<DescribeTestCasesResponse> {
    private final CodeBuildAsyncClient client;
    private final DescribeTestCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTestCasesPublisher(CodeBuildAsyncClient client, DescribeTestCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTestCasesPublisher(CodeBuildAsyncClient client, DescribeTestCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTestCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTestCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestCase> testCases() {
        Function<DescribeTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testCases() != null) {
                return response.testCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTestCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTestCasesResponseFetcher
    implements AsyncPageFetcher<DescribeTestCasesResponse> {
        private DescribeTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTestCasesResponse> nextPage(DescribeTestCasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTestCasesPublisher.this.client.describeTestCases(DescribeTestCasesPublisher.this.firstRequest);
            }
            return DescribeTestCasesPublisher.this.client.describeTestCases((DescribeTestCasesRequest)((Object)DescribeTestCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

