/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildStatusConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildStatusConfig> {
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("context").getter(BuildStatusConfig.getter(BuildStatusConfig::context)).setter(BuildStatusConfig.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<String> TARGET_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetUrl").getter(BuildStatusConfig.getter(BuildStatusConfig::targetUrl)).setter(BuildStatusConfig.setter(Builder::targetUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD, TARGET_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String context;
    private final String targetUrl;

    private BuildStatusConfig(BuilderImpl builder) {
        this.context = builder.context;
        this.targetUrl = builder.targetUrl;
    }

    public String context() {
        return this.context;
    }

    public String targetUrl() {
        return this.targetUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildStatusConfig)) {
            return false;
        }
        BuildStatusConfig other = (BuildStatusConfig)obj;
        return Objects.equals(this.context(), other.context()) && Objects.equals(this.targetUrl(), other.targetUrl());
    }

    public String toString() {
        return ToString.builder((String)"BuildStatusConfig").add("Context", (Object)this.context()).add("TargetUrl", (Object)this.targetUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "targetUrl": {
                return Optional.ofNullable(clazz.cast(this.targetUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildStatusConfig, T> g) {
        return obj -> g.apply((BuildStatusConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String context;
        private String targetUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildStatusConfig model) {
            this.context(model.context);
            this.targetUrl(model.targetUrl);
        }

        public final String getContext() {
            return this.context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        public final String getTargetUrl() {
            return this.targetUrl;
        }

        @Override
        public final Builder targetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
            return this;
        }

        public final void setTargetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
        }

        public BuildStatusConfig build() {
            return new BuildStatusConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildStatusConfig> {
        public Builder context(String var1);

        public Builder targetUrl(String var1);
    }
}

