/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a test case created using a framework such as NUnit or Cucumber. A test case might be a unit test
 * or a configuration test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCase implements SdkPojo, Serializable, ToCopyableBuilder<TestCase.Builder, TestCase> {
    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestCase::reportArn)).setter(setter(Builder::reportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArn").build()).build();

    private static final SdkField<String> TEST_RAW_DATA_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestCase::testRawDataPath)).setter(setter(Builder::testRawDataPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRawDataPath").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestCase::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestCase::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestCase::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> DURATION_IN_NANO_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TestCase::durationInNanoSeconds)).setter(setter(Builder::durationInNanoSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInNanoSeconds").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestCase::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Instant> EXPIRED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TestCase::expired)).setter(setter(Builder::expired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expired").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARN_FIELD,
            TEST_RAW_DATA_PATH_FIELD, PREFIX_FIELD, NAME_FIELD, STATUS_FIELD, DURATION_IN_NANO_SECONDS_FIELD, MESSAGE_FIELD,
            EXPIRED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportArn;

    private final String testRawDataPath;

    private final String prefix;

    private final String name;

    private final String status;

    private final Long durationInNanoSeconds;

    private final String message;

    private final Instant expired;

    private TestCase(BuilderImpl builder) {
        this.reportArn = builder.reportArn;
        this.testRawDataPath = builder.testRawDataPath;
        this.prefix = builder.prefix;
        this.name = builder.name;
        this.status = builder.status;
        this.durationInNanoSeconds = builder.durationInNanoSeconds;
        this.message = builder.message;
        this.expired = builder.expired;
    }

    /**
     * <p>
     * The ARN of the report to which the test case belongs.
     * </p>
     * 
     * @return The ARN of the report to which the test case belongs.
     */
    public String reportArn() {
        return reportArn;
    }

    /**
     * <p>
     * The path to the raw data file that contains the test result.
     * </p>
     * 
     * @return The path to the raw data file that contains the test result.
     */
    public String testRawDataPath() {
        return testRawDataPath;
    }

    /**
     * <p>
     * A string that is applied to a series of related test cases. CodeBuild generates the prefix. The prefix depends on
     * the framework used to generate the tests.
     * </p>
     * 
     * @return A string that is applied to a series of related test cases. CodeBuild generates the prefix. The prefix
     *         depends on the framework used to generate the tests.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The name of the test case.
     * </p>
     * 
     * @return The name of the test case.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status returned by the test case after it was run. Valid statuses are <code>SUCCEEDED</code>,
     * <code>FAILED</code>, <code>ERROR</code>, <code>SKIPPED</code>, and <code>UNKNOWN</code>.
     * </p>
     * 
     * @return The status returned by the test case after it was run. Valid statuses are <code>SUCCEEDED</code>,
     *         <code>FAILED</code>, <code>ERROR</code>, <code>SKIPPED</code>, and <code>UNKNOWN</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The number of nanoseconds it took to run this test case.
     * </p>
     * 
     * @return The number of nanoseconds it took to run this test case.
     */
    public Long durationInNanoSeconds() {
        return durationInNanoSeconds;
    }

    /**
     * <p>
     * A message associated with a test case. For example, an error message or stack trace.
     * </p>
     * 
     * @return A message associated with a test case. For example, an error message or stack trace.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The date and time a test case expires. A test case expires 30 days after it is created. An expired test case is
     * not available to view in CodeBuild.
     * </p>
     * 
     * @return The date and time a test case expires. A test case expires 30 days after it is created. An expired test
     *         case is not available to view in CodeBuild.
     */
    public Instant expired() {
        return expired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportArn());
        hashCode = 31 * hashCode + Objects.hashCode(testRawDataPath());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(durationInNanoSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(expired());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCase)) {
            return false;
        }
        TestCase other = (TestCase) obj;
        return Objects.equals(reportArn(), other.reportArn()) && Objects.equals(testRawDataPath(), other.testRawDataPath())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status())
                && Objects.equals(durationInNanoSeconds(), other.durationInNanoSeconds())
                && Objects.equals(message(), other.message()) && Objects.equals(expired(), other.expired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestCase").add("ReportArn", reportArn()).add("TestRawDataPath", testRawDataPath())
                .add("Prefix", prefix()).add("Name", name()).add("Status", status())
                .add("DurationInNanoSeconds", durationInNanoSeconds()).add("Message", message()).add("Expired", expired())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportArn":
            return Optional.ofNullable(clazz.cast(reportArn()));
        case "testRawDataPath":
            return Optional.ofNullable(clazz.cast(testRawDataPath()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "durationInNanoSeconds":
            return Optional.ofNullable(clazz.cast(durationInNanoSeconds()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "expired":
            return Optional.ofNullable(clazz.cast(expired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCase, T> g) {
        return obj -> g.apply((TestCase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCase> {
        /**
         * <p>
         * The ARN of the report to which the test case belongs.
         * </p>
         * 
         * @param reportArn
         *        The ARN of the report to which the test case belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportArn(String reportArn);

        /**
         * <p>
         * The path to the raw data file that contains the test result.
         * </p>
         * 
         * @param testRawDataPath
         *        The path to the raw data file that contains the test result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRawDataPath(String testRawDataPath);

        /**
         * <p>
         * A string that is applied to a series of related test cases. CodeBuild generates the prefix. The prefix
         * depends on the framework used to generate the tests.
         * </p>
         * 
         * @param prefix
         *        A string that is applied to a series of related test cases. CodeBuild generates the prefix. The prefix
         *        depends on the framework used to generate the tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The name of the test case.
         * </p>
         * 
         * @param name
         *        The name of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status returned by the test case after it was run. Valid statuses are <code>SUCCEEDED</code>,
         * <code>FAILED</code>, <code>ERROR</code>, <code>SKIPPED</code>, and <code>UNKNOWN</code>.
         * </p>
         * 
         * @param status
         *        The status returned by the test case after it was run. Valid statuses are <code>SUCCEEDED</code>,
         *        <code>FAILED</code>, <code>ERROR</code>, <code>SKIPPED</code>, and <code>UNKNOWN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of nanoseconds it took to run this test case.
         * </p>
         * 
         * @param durationInNanoSeconds
         *        The number of nanoseconds it took to run this test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInNanoSeconds(Long durationInNanoSeconds);

        /**
         * <p>
         * A message associated with a test case. For example, an error message or stack trace.
         * </p>
         * 
         * @param message
         *        A message associated with a test case. For example, an error message or stack trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The date and time a test case expires. A test case expires 30 days after it is created. An expired test case
         * is not available to view in CodeBuild.
         * </p>
         * 
         * @param expired
         *        The date and time a test case expires. A test case expires 30 days after it is created. An expired
         *        test case is not available to view in CodeBuild.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expired(Instant expired);
    }

    static final class BuilderImpl implements Builder {
        private String reportArn;

        private String testRawDataPath;

        private String prefix;

        private String name;

        private String status;

        private Long durationInNanoSeconds;

        private String message;

        private Instant expired;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCase model) {
            reportArn(model.reportArn);
            testRawDataPath(model.testRawDataPath);
            prefix(model.prefix);
            name(model.name);
            status(model.status);
            durationInNanoSeconds(model.durationInNanoSeconds);
            message(model.message);
            expired(model.expired);
        }

        public final String getReportArn() {
            return reportArn;
        }

        @Override
        public final Builder reportArn(String reportArn) {
            this.reportArn = reportArn;
            return this;
        }

        public final void setReportArn(String reportArn) {
            this.reportArn = reportArn;
        }

        public final String getTestRawDataPath() {
            return testRawDataPath;
        }

        @Override
        public final Builder testRawDataPath(String testRawDataPath) {
            this.testRawDataPath = testRawDataPath;
            return this;
        }

        public final void setTestRawDataPath(String testRawDataPath) {
            this.testRawDataPath = testRawDataPath;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getDurationInNanoSeconds() {
            return durationInNanoSeconds;
        }

        @Override
        public final Builder durationInNanoSeconds(Long durationInNanoSeconds) {
            this.durationInNanoSeconds = durationInNanoSeconds;
            return this;
        }

        public final void setDurationInNanoSeconds(Long durationInNanoSeconds) {
            this.durationInNanoSeconds = durationInNanoSeconds;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getExpired() {
            return expired;
        }

        @Override
        public final Builder expired(Instant expired) {
            this.expired = expired;
            return this;
        }

        public final void setExpired(Instant expired) {
            this.expired = expired;
        }

        @Override
        public TestCase build() {
            return new TestCase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
