/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the credentials for a GitHub, GitHub Enterprise, or Bitbucket repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCredentialsInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceCredentialsInfo.Builder, SourceCredentialsInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceCredentialsInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceCredentialsInfo::serverTypeAsString)).setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceCredentialsInfo::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SERVER_TYPE_FIELD,
            AUTH_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String serverType;

    private final String authType;

    private SourceCredentialsInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.serverType = builder.serverType;
        this.authType = builder.authType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the token.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the token.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
     * @see ServerType
     */
    public ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
     * @see ServerType
     */
    public String serverTypeAsString() {
        return serverType;
    }

    /**
     * <p>
     * The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
     * PERSONAL_ACCESS_TOKEN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
     *         PERSONAL_ACCESS_TOKEN.
     * @see AuthType
     */
    public AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
     * PERSONAL_ACCESS_TOKEN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
     *         PERSONAL_ACCESS_TOKEN.
     * @see AuthType
     */
    public String authTypeAsString() {
        return authType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCredentialsInfo)) {
            return false;
        }
        SourceCredentialsInfo other = (SourceCredentialsInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(serverTypeAsString(), other.serverTypeAsString())
                && Objects.equals(authTypeAsString(), other.authTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceCredentialsInfo").add("Arn", arn()).add("ServerType", serverTypeAsString())
                .add("AuthType", authTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "serverType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCredentialsInfo, T> g) {
        return obj -> g.apply((SourceCredentialsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCredentialsInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the token.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
         * </p>
         * 
         * @param serverType
         *        The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
         * </p>
         * 
         * @param serverType
         *        The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);

        /**
         * <p>
         * The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
         * PERSONAL_ACCESS_TOKEN.
         * </p>
         * 
         * @param authType
         *        The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
         *        PERSONAL_ACCESS_TOKEN.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
         * PERSONAL_ACCESS_TOKEN.
         * </p>
         * 
         * @param authType
         *        The type of authentication used by the credentials. Valid options are OAUTH, BASIC_AUTH, or
         *        PERSONAL_ACCESS_TOKEN.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String serverType;

        private String authType;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCredentialsInfo model) {
            arn(model.arn);
            serverType(model.serverType);
            authType(model.authType);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getServerType() {
            return serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final String getAuthType() {
            return authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public SourceCredentialsInfo build() {
            return new SourceCredentialsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
