/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthType {
    OAUTH("OAUTH"),
    BASIC_AUTH("BASIC_AUTH"),
    PERSONAL_ACCESS_TOKEN("PERSONAL_ACCESS_TOKEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthType> knownValues() {
        return Stream.of(AuthType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

