/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.AuthType;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ServerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSourceCredentialsRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, ImportSourceCredentialsRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::username)).setter(ImportSourceCredentialsRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::token)).setter(ImportSourceCredentialsRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::serverTypeAsString)).setter(ImportSourceCredentialsRequest.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::authTypeAsString)).setter(ImportSourceCredentialsRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, TOKEN_FIELD, SERVER_TYPE_FIELD, AUTH_TYPE_FIELD));
    private final String username;
    private final String token;
    private final String serverType;
    private final String authType;

    private ImportSourceCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.token = builder.token;
        this.serverType = builder.serverType;
        this.authType = builder.authType;
    }

    public String username() {
        return this.username;
    }

    public String token() {
        return this.token;
    }

    public ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public String serverTypeAsString() {
        return this.serverType;
    }

    public AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public String authTypeAsString() {
        return this.authType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSourceCredentialsRequest)) {
            return false;
        }
        ImportSourceCredentialsRequest other = (ImportSourceCredentialsRequest)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ImportSourceCredentialsRequest").add("Username", (Object)this.username()).add("Token", (Object)this.token()).add("ServerType", (Object)this.serverTypeAsString()).add("AuthType", (Object)this.authTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSourceCredentialsRequest, T> g) {
        return obj -> g.apply((ImportSourceCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String username;
        private String token;
        private String serverType;
        private String authType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSourceCredentialsRequest model) {
            super(model);
            this.username(model.username);
            this.token(model.token);
            this.serverType(model.serverType);
            this.authType(model.authType);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getServerType() {
            return this.serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final String getAuthType() {
            return this.authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType.toString());
            return this;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSourceCredentialsRequest build() {
            return new ImportSourceCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportSourceCredentialsRequest> {
        public Builder username(String var1);

        public Builder token(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

