/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;

@SdkInternalApi
public class BuildPhaseMarshaller {
    private static final MarshallingInfo<String> PHASETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseType").build();
    private static final MarshallingInfo<String> PHASESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseStatus").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").build();
    private static final MarshallingInfo<Long> DURATIONINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationInSeconds").build();
    private static final MarshallingInfo<List> CONTEXTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contexts").build();
    private static final BuildPhaseMarshaller INSTANCE = new BuildPhaseMarshaller();

    public static BuildPhaseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BuildPhase buildPhase, ProtocolMarshaller protocolMarshaller) {
        if (buildPhase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)buildPhase.phaseTypeString(), PHASETYPE_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.phaseStatusString(), PHASESTATUS_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.durationInSeconds(), DURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall(buildPhase.contexts(), CONTEXTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

