/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildNotDeleted;
import software.amazon.awssdk.services.codebuild.model.BuildsNotDeletedCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteBuildsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchDeleteBuildsResponse> {
    private final List<String> buildsDeleted;
    private final List<BuildNotDeleted> buildsNotDeleted;

    private BatchDeleteBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.buildsDeleted = builder.buildsDeleted;
        this.buildsNotDeleted = builder.buildsNotDeleted;
    }

    public List<String> buildsDeleted() {
        return this.buildsDeleted;
    }

    public List<BuildNotDeleted> buildsNotDeleted() {
        return this.buildsNotDeleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.buildsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildsNotDeleted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteBuildsResponse)) {
            return false;
        }
        BatchDeleteBuildsResponse other = (BatchDeleteBuildsResponse)((Object)obj);
        return Objects.equals(this.buildsDeleted(), other.buildsDeleted()) && Objects.equals(this.buildsNotDeleted(), other.buildsNotDeleted());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.buildsDeleted() != null) {
            sb.append("BuildsDeleted: ").append(this.buildsDeleted()).append(",");
        }
        if (this.buildsNotDeleted() != null) {
            sb.append("BuildsNotDeleted: ").append(this.buildsNotDeleted()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "buildsDeleted": {
                return Optional.of(clazz.cast(this.buildsDeleted()));
            }
            case "buildsNotDeleted": {
                return Optional.of(clazz.cast(this.buildsNotDeleted()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<String> buildsDeleted;
        private List<BuildNotDeleted> buildsNotDeleted;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteBuildsResponse model) {
            this.buildsDeleted(model.buildsDeleted);
            this.buildsNotDeleted(model.buildsNotDeleted);
        }

        public final Collection<String> getBuildsDeleted() {
            return this.buildsDeleted;
        }

        @Override
        public final Builder buildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsDeleted(String ... buildsDeleted) {
            this.buildsDeleted(Arrays.asList(buildsDeleted));
            return this;
        }

        public final void setBuildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
        }

        public final Collection<BuildNotDeleted.Builder> getBuildsNotDeleted() {
            return this.buildsNotDeleted != null ? (Collection)this.buildsNotDeleted.stream().map(BuildNotDeleted::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copy(buildsNotDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(BuildNotDeleted ... buildsNotDeleted) {
            this.buildsNotDeleted(Arrays.asList(buildsNotDeleted));
            return this;
        }

        public final void setBuildsNotDeleted(Collection<BuildNotDeleted.BuilderImpl> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copyFromBuilder(buildsNotDeleted);
        }

        @Override
        public BatchDeleteBuildsResponse build() {
            return new BatchDeleteBuildsResponse(this);
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    CopyableBuilder<Builder, BatchDeleteBuildsResponse> {
        public Builder buildsDeleted(Collection<String> var1);

        public Builder buildsDeleted(String ... var1);

        public Builder buildsNotDeleted(Collection<BuildNotDeleted> var1);

        public Builder buildsNotDeleted(BuildNotDeleted ... var1);
    }
}

