/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;

@SdkInternalApi
public class ProjectSourceMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> BUILDSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildspec").build();
    private static final MarshallingInfo<StructuredPojo> AUTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("auth").build();
    private static final ProjectSourceMarshaller INSTANCE = new ProjectSourceMarshaller();

    public static ProjectSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectSource projectSource, ProtocolMarshaller protocolMarshaller) {
        if (projectSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)projectSource.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)projectSource.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)projectSource.buildspec(), BUILDSPEC_BINDING);
            protocolMarshaller.marshall((Object)projectSource.auth(), AUTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

