/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.BuildArtifactsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuildArtifacts
implements StructuredPojo,
ToCopyableBuilder<Builder, BuildArtifacts> {
    private final String location;
    private final String sha256sum;
    private final String md5sum;

    private BuildArtifacts(BuilderImpl builder) {
        this.location = builder.location;
        this.sha256sum = builder.sha256sum;
        this.md5sum = builder.md5sum;
    }

    public String location() {
        return this.location;
    }

    public String sha256sum() {
        return this.sha256sum;
    }

    public String md5sum() {
        return this.md5sum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5sum());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildArtifacts)) {
            return false;
        }
        BuildArtifacts other = (BuildArtifacts)obj;
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.sha256sum(), other.sha256sum()) && Objects.equals(this.md5sum(), other.md5sum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.sha256sum() != null) {
            sb.append("Sha256sum: ").append(this.sha256sum()).append(",");
        }
        if (this.md5sum() != null) {
            sb.append("Md5sum: ").append(this.md5sum()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "sha256sum": {
                return Optional.of(clazz.cast(this.sha256sum()));
            }
            case "md5sum": {
                return Optional.of(clazz.cast(this.md5sum()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildArtifactsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private String sha256sum;
        private String md5sum;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildArtifacts model) {
            this.location(model.location);
            this.sha256sum(model.sha256sum);
            this.md5sum(model.md5sum);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getSha256sum() {
            return this.sha256sum;
        }

        @Override
        public final Builder sha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
            return this;
        }

        public final void setSha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
        }

        public final String getMd5sum() {
            return this.md5sum;
        }

        @Override
        public final Builder md5sum(String md5sum) {
            this.md5sum = md5sum;
            return this;
        }

        public final void setMd5sum(String md5sum) {
            this.md5sum = md5sum;
        }

        public BuildArtifacts build() {
            return new BuildArtifacts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuildArtifacts> {
        public Builder location(String var1);

        public Builder sha256sum(String var1);

        public Builder md5sum(String var1);
    }
}

