/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetBuildsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetBuildsResponse> {
    private final List<Build> builds;
    private final List<String> buildsNotFound;

    private BatchGetBuildsResponse(BuilderImpl builder) {
        this.builds = builder.builds;
        this.buildsNotFound = builder.buildsNotFound;
    }

    public List<Build> builds() {
        return this.builds;
    }

    public List<String> buildsNotFound() {
        return this.buildsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.builds() == null ? 0 : this.builds().hashCode());
        hashCode = 31 * hashCode + (this.buildsNotFound() == null ? 0 : this.buildsNotFound().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildsResponse)) {
            return false;
        }
        BatchGetBuildsResponse other = (BatchGetBuildsResponse)((Object)obj);
        if (other.builds() == null ^ this.builds() == null) {
            return false;
        }
        if (other.builds() != null && !other.builds().equals(this.builds())) {
            return false;
        }
        if (other.buildsNotFound() == null ^ this.buildsNotFound() == null) {
            return false;
        }
        return other.buildsNotFound() == null || other.buildsNotFound().equals(this.buildsNotFound());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.builds() != null) {
            sb.append("Builds: ").append(this.builds()).append(",");
        }
        if (this.buildsNotFound() != null) {
            sb.append("BuildsNotFound: ").append(this.buildsNotFound()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Build> builds;
        private List<String> buildsNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildsResponse model) {
            this.setBuilds(model.builds);
            this.setBuildsNotFound(model.buildsNotFound);
        }

        public final Collection<Build> getBuilds() {
            return this.builds;
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildsCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build ... builds) {
            this.builds(Arrays.asList(builds));
            return this;
        }

        public final void setBuilds(Collection<Build> builds) {
            this.builds = BuildsCopier.copy(builds);
        }

        @SafeVarargs
        public final void setBuilds(Build ... builds) {
            this.builds(Arrays.asList(builds));
        }

        public final Collection<String> getBuildsNotFound() {
            return this.buildsNotFound;
        }

        @Override
        public final Builder buildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotFound(String ... buildsNotFound) {
            this.buildsNotFound(Arrays.asList(buildsNotFound));
            return this;
        }

        public final void setBuildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
        }

        @SafeVarargs
        public final void setBuildsNotFound(String ... buildsNotFound) {
            this.buildsNotFound(Arrays.asList(buildsNotFound));
        }

        public BatchGetBuildsResponse build() {
            return new BatchGetBuildsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetBuildsResponse> {
        public Builder builds(Collection<Build> var1);

        public Builder builds(Build ... var1);

        public Builder buildsNotFound(Collection<String> var1);

        public Builder buildsNotFound(String ... var1);
    }
}

