/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectArtifactsMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").isBinary(false).build();
    private static final MarshallingInfo<String> NAMESPACETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("namespaceType").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> PACKAGING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packaging").isBinary(false).build();
    private static final MarshallingInfo<Boolean> OVERRIDEARTIFACTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("overrideArtifactName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENCRYPTIONDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionDisabled").isBinary(false).build();
    private static final MarshallingInfo<String> ARTIFACTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactIdentifier").isBinary(false).build();
    private static final ProjectArtifactsMarshaller INSTANCE = new ProjectArtifactsMarshaller();

    private ProjectArtifactsMarshaller() {
    }

    public static ProjectArtifactsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectArtifacts projectArtifacts, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projectArtifacts, (String)"projectArtifacts");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projectArtifacts.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.namespaceTypeAsString(), NAMESPACETYPE_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.packagingAsString(), PACKAGING_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.overrideArtifactName(), OVERRIDEARTIFACTNAME_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.encryptionDisabled(), ENCRYPTIONDISABLED_BINDING);
            protocolMarshaller.marshall((Object)projectArtifacts.artifactIdentifier(), ARTIFACTIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

