/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LanguageType {
    JAVA("JAVA"),
    PYTHON("PYTHON"),
    NODE_JS("NODE_JS"),
    RUBY("RUBY"),
    GOLANG("GOLANG"),
    DOCKER("DOCKER"),
    ANDROID("ANDROID"),
    DOTNET("DOTNET"),
    BASE("BASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LanguageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LanguageType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageType> knownValues() {
        return Stream.of(LanguageType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

