/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnvironmentPlatformMarshaller {
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();
    private static final MarshallingInfo<List> LANGUAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languages").isBinary(false).build();
    private static final EnvironmentPlatformMarshaller INSTANCE = new EnvironmentPlatformMarshaller();

    private EnvironmentPlatformMarshaller() {
    }

    public static EnvironmentPlatformMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnvironmentPlatform environmentPlatform, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)environmentPlatform, (String)"environmentPlatform");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)environmentPlatform.platformAsString(), PLATFORM_BINDING);
            protocolMarshaller.marshall(environmentPlatform.languages(), LANGUAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

