/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.LicenseInfo;
import software.amazon.awssdk.services.codeartifact.model.LicenseInfoListCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionOrigin;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageVersionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageVersionDescription> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(PackageVersionDescription.getter(PackageVersionDescription::formatAsString)).setter(PackageVersionDescription.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PackageVersionDescription.getter(PackageVersionDescription::namespace)).setter(PackageVersionDescription.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(PackageVersionDescription.getter(PackageVersionDescription::packageName)).setter(PackageVersionDescription.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(PackageVersionDescription.getter(PackageVersionDescription::displayName)).setter(PackageVersionDescription.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(PackageVersionDescription.getter(PackageVersionDescription::version)).setter(PackageVersionDescription.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(PackageVersionDescription.getter(PackageVersionDescription::summary)).setter(PackageVersionDescription.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> HOME_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("homePage").getter(PackageVersionDescription.getter(PackageVersionDescription::homePage)).setter(PackageVersionDescription.setter(Builder::homePage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePage").build()}).build();
    private static final SdkField<String> SOURCE_CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCodeRepository").getter(PackageVersionDescription.getter(PackageVersionDescription::sourceCodeRepository)).setter(PackageVersionDescription.setter(Builder::sourceCodeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeRepository").build()}).build();
    private static final SdkField<Instant> PUBLISHED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("publishedTime").getter(PackageVersionDescription.getter(PackageVersionDescription::publishedTime)).setter(PackageVersionDescription.setter(Builder::publishedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishedTime").build()}).build();
    private static final SdkField<List<LicenseInfo>> LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenses").getter(PackageVersionDescription.getter(PackageVersionDescription::licenses)).setter(PackageVersionDescription.setter(Builder::licenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(PackageVersionDescription.getter(PackageVersionDescription::revision)).setter(PackageVersionDescription.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PackageVersionDescription.getter(PackageVersionDescription::statusAsString)).setter(PackageVersionDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<PackageVersionOrigin> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("origin").getter(PackageVersionDescription.getter(PackageVersionDescription::origin)).setter(PackageVersionDescription.setter(Builder::origin)).constructor(PackageVersionOrigin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_NAME_FIELD, DISPLAY_NAME_FIELD, VERSION_FIELD, SUMMARY_FIELD, HOME_PAGE_FIELD, SOURCE_CODE_REPOSITORY_FIELD, PUBLISHED_TIME_FIELD, LICENSES_FIELD, REVISION_FIELD, STATUS_FIELD, ORIGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("format", FORMAT_FIELD);
            this.put("namespace", NAMESPACE_FIELD);
            this.put("packageName", PACKAGE_NAME_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("version", VERSION_FIELD);
            this.put("summary", SUMMARY_FIELD);
            this.put("homePage", HOME_PAGE_FIELD);
            this.put("sourceCodeRepository", SOURCE_CODE_REPOSITORY_FIELD);
            this.put("publishedTime", PUBLISHED_TIME_FIELD);
            this.put("licenses", LICENSES_FIELD);
            this.put("revision", REVISION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("origin", ORIGIN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String namespace;
    private final String packageName;
    private final String displayName;
    private final String version;
    private final String summary;
    private final String homePage;
    private final String sourceCodeRepository;
    private final Instant publishedTime;
    private final List<LicenseInfo> licenses;
    private final String revision;
    private final String status;
    private final PackageVersionOrigin origin;

    private PackageVersionDescription(BuilderImpl builder) {
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageName = builder.packageName;
        this.displayName = builder.displayName;
        this.version = builder.version;
        this.summary = builder.summary;
        this.homePage = builder.homePage;
        this.sourceCodeRepository = builder.sourceCodeRepository;
        this.publishedTime = builder.publishedTime;
        this.licenses = builder.licenses;
        this.revision = builder.revision;
        this.status = builder.status;
        this.origin = builder.origin;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String version() {
        return this.version;
    }

    public final String summary() {
        return this.summary;
    }

    public final String homePage() {
        return this.homePage;
    }

    public final String sourceCodeRepository() {
        return this.sourceCodeRepository;
    }

    public final Instant publishedTime() {
        return this.publishedTime;
    }

    public final boolean hasLicenses() {
        return this.licenses != null && !(this.licenses instanceof SdkAutoConstructList);
    }

    public final List<LicenseInfo> licenses() {
        return this.licenses;
    }

    public final String revision() {
        return this.revision;
    }

    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PackageVersionOrigin origin() {
        return this.origin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenses() ? this.licenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.origin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionDescription)) {
            return false;
        }
        PackageVersionDescription other = (PackageVersionDescription)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.homePage(), other.homePage()) && Objects.equals(this.sourceCodeRepository(), other.sourceCodeRepository()) && Objects.equals(this.publishedTime(), other.publishedTime()) && this.hasLicenses() == other.hasLicenses() && Objects.equals(this.licenses(), other.licenses()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.origin(), other.origin());
    }

    public final String toString() {
        return ToString.builder((String)"PackageVersionDescription").add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("PackageName", (Object)this.packageName()).add("DisplayName", (Object)this.displayName()).add("Version", (Object)this.version()).add("Summary", (Object)this.summary()).add("HomePage", (Object)this.homePage()).add("SourceCodeRepository", (Object)this.sourceCodeRepository()).add("PublishedTime", (Object)this.publishedTime()).add("Licenses", this.hasLicenses() ? this.licenses() : null).add("Revision", (Object)this.revision()).add("Status", (Object)this.statusAsString()).add("Origin", (Object)this.origin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "homePage": {
                return Optional.ofNullable(clazz.cast(this.homePage()));
            }
            case "sourceCodeRepository": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeRepository()));
            }
            case "publishedTime": {
                return Optional.ofNullable(clazz.cast(this.publishedTime()));
            }
            case "licenses": {
                return Optional.ofNullable(clazz.cast(this.licenses()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionDescription, T> g) {
        return obj -> g.apply((PackageVersionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String namespace;
        private String packageName;
        private String displayName;
        private String version;
        private String summary;
        private String homePage;
        private String sourceCodeRepository;
        private Instant publishedTime;
        private List<LicenseInfo> licenses = DefaultSdkAutoConstructList.getInstance();
        private String revision;
        private String status;
        private PackageVersionOrigin origin;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionDescription model) {
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageName(model.packageName);
            this.displayName(model.displayName);
            this.version(model.version);
            this.summary(model.summary);
            this.homePage(model.homePage);
            this.sourceCodeRepository(model.sourceCodeRepository);
            this.publishedTime(model.publishedTime);
            this.licenses(model.licenses);
            this.revision(model.revision);
            this.status(model.status);
            this.origin(model.origin);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getHomePage() {
            return this.homePage;
        }

        public final void setHomePage(String homePage) {
            this.homePage = homePage;
        }

        @Override
        public final Builder homePage(String homePage) {
            this.homePage = homePage;
            return this;
        }

        public final String getSourceCodeRepository() {
            return this.sourceCodeRepository;
        }

        public final void setSourceCodeRepository(String sourceCodeRepository) {
            this.sourceCodeRepository = sourceCodeRepository;
        }

        @Override
        public final Builder sourceCodeRepository(String sourceCodeRepository) {
            this.sourceCodeRepository = sourceCodeRepository;
            return this;
        }

        public final Instant getPublishedTime() {
            return this.publishedTime;
        }

        public final void setPublishedTime(Instant publishedTime) {
            this.publishedTime = publishedTime;
        }

        @Override
        public final Builder publishedTime(Instant publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        public final List<LicenseInfo.Builder> getLicenses() {
            List<LicenseInfo.Builder> result = LicenseInfoListCopier.copyToBuilder(this.licenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenses(Collection<LicenseInfo.BuilderImpl> licenses) {
            this.licenses = LicenseInfoListCopier.copyFromBuilder(licenses);
        }

        @Override
        public final Builder licenses(Collection<LicenseInfo> licenses) {
            this.licenses = LicenseInfoListCopier.copy(licenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(LicenseInfo ... licenses) {
            this.licenses(Arrays.asList(licenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(Consumer<LicenseInfo.Builder> ... licenses) {
            this.licenses(Stream.of(licenses).map(c -> (LicenseInfo)((LicenseInfo.Builder)LicenseInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final PackageVersionOrigin.Builder getOrigin() {
            return this.origin != null ? this.origin.toBuilder() : null;
        }

        public final void setOrigin(PackageVersionOrigin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        @Override
        public final Builder origin(PackageVersionOrigin origin) {
            this.origin = origin;
            return this;
        }

        public PackageVersionDescription build() {
            return new PackageVersionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageVersionDescription> {
        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageName(String var1);

        public Builder displayName(String var1);

        public Builder version(String var1);

        public Builder summary(String var1);

        public Builder homePage(String var1);

        public Builder sourceCodeRepository(String var1);

        public Builder publishedTime(Instant var1);

        public Builder licenses(Collection<LicenseInfo> var1);

        public Builder licenses(LicenseInfo ... var1);

        public Builder licenses(Consumer<LicenseInfo.Builder> ... var1);

        public Builder revision(String var1);

        public Builder status(String var1);

        public Builder status(PackageVersionStatus var1);

        public Builder origin(PackageVersionOrigin var1);

        default public Builder origin(Consumer<PackageVersionOrigin.Builder> origin) {
            return this.origin((PackageVersionOrigin)((PackageVersionOrigin.Builder)PackageVersionOrigin.builder().applyMutation(origin)).build());
        }
    }
}

