/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackageResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, DescribePackageResponse> {
    private static final SdkField<PackageDescription> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("package").getter(DescribePackageResponse.getter(DescribePackageResponse::packageValue)).setter(DescribePackageResponse.setter(Builder::packageValue)).constructor(PackageDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("package", PACKAGE_FIELD);
        }
    });
    private final PackageDescription packageValue;

    private DescribePackageResponse(BuilderImpl builder) {
        super(builder);
        this.packageValue = builder.packageValue;
    }

    public final PackageDescription packageValue() {
        return this.packageValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageResponse)) {
            return false;
        }
        DescribePackageResponse other = (DescribePackageResponse)((Object)obj);
        return Objects.equals(this.packageValue(), other.packageValue());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePackageResponse").add("Package", (Object)this.packageValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageResponse, T> g) {
        return obj -> g.apply((DescribePackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private PackageDescription packageValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageResponse model) {
            super(model);
            this.packageValue(model.packageValue);
        }

        public final PackageDescription.Builder getPackageValue() {
            return this.packageValue != null ? this.packageValue.toBuilder() : null;
        }

        public final void setPackageValue(PackageDescription.BuilderImpl packageValue) {
            this.packageValue = packageValue != null ? packageValue.build() : null;
        }

        @Override
        public final Builder packageValue(PackageDescription packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        @Override
        public DescribePackageResponse build() {
            return new DescribePackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackageResponse> {
        public Builder packageValue(PackageDescription var1);

        default public Builder packageValue(Consumer<PackageDescription.Builder> packageValue) {
            return this.packageValue((PackageDescription)((PackageDescription.Builder)PackageDescription.builder().applyMutation(packageValue)).build());
        }
    }
}

