/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishPackageVersionRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, PublishPackageVersionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::domain)).setter(PublishPackageVersionRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::domainOwner)).setter(PublishPackageVersionRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::repository)).setter(PublishPackageVersionRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::formatAsString)).setter(PublishPackageVersionRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::namespace)).setter(PublishPackageVersionRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::packageValue)).setter(PublishPackageVersionRequest.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageVersion").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::packageVersion)).setter(PublishPackageVersionRequest.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()}).build();
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetName").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::assetName)).setter(PublishPackageVersionRequest.setter(Builder::assetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("asset").build()}).build();
    private static final SdkField<String> ASSET_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetSHA256").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::assetSHA256)).setter(PublishPackageVersionRequest.setter(Builder::assetSHA256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-content-sha256").build()}).build();
    private static final SdkField<Boolean> UNFINISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("unfinished").getter(PublishPackageVersionRequest.getter(PublishPackageVersionRequest::unfinished)).setter(PublishPackageVersionRequest.setter(Builder::unfinished)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("unfinished").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, PACKAGE_VERSION_FIELD, ASSET_NAME_FIELD, ASSET_SHA256_FIELD, UNFINISHED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domain", DOMAIN_FIELD);
            this.put("domain-owner", DOMAIN_OWNER_FIELD);
            this.put("repository", REPOSITORY_FIELD);
            this.put("format", FORMAT_FIELD);
            this.put("namespace", NAMESPACE_FIELD);
            this.put("package", PACKAGE_FIELD);
            this.put("version", PACKAGE_VERSION_FIELD);
            this.put("asset", ASSET_NAME_FIELD);
            this.put("x-amz-content-sha256", ASSET_SHA256_FIELD);
            this.put("unfinished", UNFINISHED_FIELD);
        }
    });
    private final String domain;
    private final String domainOwner;
    private final String repository;
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final String packageVersion;
    private final String assetName;
    private final String assetSHA256;
    private final Boolean unfinished;

    private PublishPackageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.packageVersion = builder.packageVersion;
        this.assetName = builder.assetName;
        this.assetSHA256 = builder.assetSHA256;
        this.unfinished = builder.unfinished;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String repository() {
        return this.repository;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String assetName() {
        return this.assetName;
    }

    public final String assetSHA256() {
        return this.assetSHA256;
    }

    public final Boolean unfinished() {
        return this.unfinished;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetSHA256());
        hashCode = 31 * hashCode + Objects.hashCode(this.unfinished());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishPackageVersionRequest)) {
            return false;
        }
        PublishPackageVersionRequest other = (PublishPackageVersionRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.assetName(), other.assetName()) && Objects.equals(this.assetSHA256(), other.assetSHA256()) && Objects.equals(this.unfinished(), other.unfinished());
    }

    public final String toString() {
        return ToString.builder((String)"PublishPackageVersionRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("Repository", (Object)this.repository()).add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("PackageVersion", (Object)this.packageVersion()).add("AssetName", (Object)this.assetName()).add("AssetSHA256", (Object)this.assetSHA256()).add("Unfinished", (Object)this.unfinished()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "packageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "assetName": {
                return Optional.ofNullable(clazz.cast(this.assetName()));
            }
            case "assetSHA256": {
                return Optional.ofNullable(clazz.cast(this.assetSHA256()));
            }
            case "unfinished": {
                return Optional.ofNullable(clazz.cast(this.unfinished()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublishPackageVersionRequest, T> g) {
        return obj -> g.apply((PublishPackageVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String repository;
        private String format;
        private String namespace;
        private String packageValue;
        private String packageVersion;
        private String assetName;
        private String assetSHA256;
        private Boolean unfinished;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishPackageVersionRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.repository(model.repository);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.packageVersion(model.packageVersion);
            this.assetName(model.assetName);
            this.assetSHA256(model.assetSHA256);
            this.unfinished(model.unfinished);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getAssetName() {
            return this.assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getAssetSHA256() {
            return this.assetSHA256;
        }

        public final void setAssetSHA256(String assetSHA256) {
            this.assetSHA256 = assetSHA256;
        }

        @Override
        public final Builder assetSHA256(String assetSHA256) {
            this.assetSHA256 = assetSHA256;
            return this;
        }

        public final Boolean getUnfinished() {
            return this.unfinished;
        }

        public final void setUnfinished(Boolean unfinished) {
            this.unfinished = unfinished;
        }

        @Override
        public final Builder unfinished(Boolean unfinished) {
            this.unfinished = unfinished;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishPackageVersionRequest build() {
            return new PublishPackageVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishPackageVersionRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder repository(String var1);

        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder packageVersion(String var1);

        public Builder assetName(String var1);

        public Builder assetSHA256(String var1);

        public Builder unfinished(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

