/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPackageVersionAssetResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, GetPackageVersionAssetResponse> {
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetName").getter(GetPackageVersionAssetResponse.getter(GetPackageVersionAssetResponse::assetName)).setter(GetPackageVersionAssetResponse.setter(Builder::assetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-AssetName").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageVersion").getter(GetPackageVersionAssetResponse.getter(GetPackageVersionAssetResponse::packageVersion)).setter(GetPackageVersionAssetResponse.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-PackageVersion").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageVersionRevision").getter(GetPackageVersionAssetResponse.getter(GetPackageVersionAssetResponse::packageVersionRevision)).setter(GetPackageVersionAssetResponse.setter(Builder::packageVersionRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-PackageVersionRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_NAME_FIELD, PACKAGE_VERSION_FIELD, PACKAGE_VERSION_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("X-AssetName", ASSET_NAME_FIELD);
            this.put("X-PackageVersion", PACKAGE_VERSION_FIELD);
            this.put("X-PackageVersionRevision", PACKAGE_VERSION_REVISION_FIELD);
        }
    });
    private final String assetName;
    private final String packageVersion;
    private final String packageVersionRevision;

    private GetPackageVersionAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetName = builder.assetName;
        this.packageVersion = builder.packageVersion;
        this.packageVersionRevision = builder.packageVersionRevision;
    }

    public final String assetName() {
        return this.assetName;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String packageVersionRevision() {
        return this.packageVersionRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersionRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionAssetResponse)) {
            return false;
        }
        GetPackageVersionAssetResponse other = (GetPackageVersionAssetResponse)((Object)obj);
        return Objects.equals(this.assetName(), other.assetName()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.packageVersionRevision(), other.packageVersionRevision());
    }

    public final String toString() {
        return ToString.builder((String)"GetPackageVersionAssetResponse").add("AssetName", (Object)this.assetName()).add("PackageVersion", (Object)this.packageVersion()).add("PackageVersionRevision", (Object)this.packageVersionRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetName": {
                return Optional.ofNullable(clazz.cast(this.assetName()));
            }
            case "packageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "packageVersionRevision": {
                return Optional.ofNullable(clazz.cast(this.packageVersionRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionAssetResponse, T> g) {
        return obj -> g.apply((GetPackageVersionAssetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private String assetName;
        private String packageVersion;
        private String packageVersionRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionAssetResponse model) {
            super(model);
            this.assetName(model.assetName);
            this.packageVersion(model.packageVersion);
            this.packageVersionRevision(model.packageVersionRevision);
        }

        public final String getAssetName() {
            return this.assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPackageVersionRevision() {
            return this.packageVersionRevision;
        }

        public final void setPackageVersionRevision(String packageVersionRevision) {
            this.packageVersionRevision = packageVersionRevision;
        }

        @Override
        public final Builder packageVersionRevision(String packageVersionRevision) {
            this.packageVersionRevision = packageVersionRevision;
            return this;
        }

        @Override
        public GetPackageVersionAssetResponse build() {
            return new GetPackageVersionAssetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPackageVersionAssetResponse> {
        public Builder assetName(String var1);

        public Builder packageVersion(String var1);

        public Builder packageVersionRevision(String var1);
    }
}

