/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupAssociationType;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedPackageGroupResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, GetAssociatedPackageGroupResponse> {
    private static final SdkField<PackageGroupDescription> PACKAGE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageGroup").getter(GetAssociatedPackageGroupResponse.getter(GetAssociatedPackageGroupResponse::packageGroup)).setter(GetAssociatedPackageGroupResponse.setter(Builder::packageGroup)).constructor(PackageGroupDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroup").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationType").getter(GetAssociatedPackageGroupResponse.getter(GetAssociatedPackageGroupResponse::associationTypeAsString)).setter(GetAssociatedPackageGroupResponse.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUP_FIELD, ASSOCIATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("packageGroup", PACKAGE_GROUP_FIELD);
            this.put("associationType", ASSOCIATION_TYPE_FIELD);
        }
    });
    private final PackageGroupDescription packageGroup;
    private final String associationType;

    private GetAssociatedPackageGroupResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroup = builder.packageGroup;
        this.associationType = builder.associationType;
    }

    public final PackageGroupDescription packageGroup() {
        return this.packageGroup;
    }

    public final PackageGroupAssociationType associationType() {
        return PackageGroupAssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedPackageGroupResponse)) {
            return false;
        }
        GetAssociatedPackageGroupResponse other = (GetAssociatedPackageGroupResponse)((Object)obj);
        return Objects.equals(this.packageGroup(), other.packageGroup()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssociatedPackageGroupResponse").add("PackageGroup", (Object)this.packageGroup()).add("AssociationType", (Object)this.associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageGroup": {
                return Optional.ofNullable(clazz.cast(this.packageGroup()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedPackageGroupResponse, T> g) {
        return obj -> g.apply((GetAssociatedPackageGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private PackageGroupDescription packageGroup;
        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedPackageGroupResponse model) {
            super(model);
            this.packageGroup(model.packageGroup);
            this.associationType(model.associationType);
        }

        public final PackageGroupDescription.Builder getPackageGroup() {
            return this.packageGroup != null ? this.packageGroup.toBuilder() : null;
        }

        public final void setPackageGroup(PackageGroupDescription.BuilderImpl packageGroup) {
            this.packageGroup = packageGroup != null ? packageGroup.build() : null;
        }

        @Override
        public final Builder packageGroup(PackageGroupDescription packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(PackageGroupAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        @Override
        public GetAssociatedPackageGroupResponse build() {
            return new GetAssociatedPackageGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedPackageGroupResponse> {
        public Builder packageGroup(PackageGroupDescription var1);

        default public Builder packageGroup(Consumer<PackageGroupDescription.Builder> packageGroup) {
            return this.packageGroup((PackageGroupDescription)((PackageGroupDescription.Builder)PackageGroupDescription.builder().applyMutation(packageGroup)).build());
        }

        public Builder associationType(String var1);

        public Builder associationType(PackageGroupAssociationType var1);
    }
}

