/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.CodeartifactClientBuilder;
import software.amazon.awssdk.services.codeartifact.CodeartifactServiceClientConfiguration;
import software.amazon.awssdk.services.codeartifact.DefaultCodeartifactBaseClientBuilder;
import software.amazon.awssdk.services.codeartifact.DefaultCodeartifactClient;
import software.amazon.awssdk.services.codeartifact.endpoints.CodeartifactEndpointProvider;

@SdkInternalApi
final class DefaultCodeartifactClientBuilder
extends DefaultCodeartifactBaseClientBuilder<CodeartifactClientBuilder, CodeartifactClient>
implements CodeartifactClientBuilder {
    DefaultCodeartifactClientBuilder() {
    }

    @Override
    public DefaultCodeartifactClientBuilder endpointProvider(CodeartifactEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeartifactClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeartifactClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeartifactServiceClientConfiguration serviceClientConfiguration = CodeartifactServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeartifactClient(serviceClientConfiguration, clientConfiguration);
    }
}

