/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRepositoryPermissionsPolicyRequest extends CodeartifactRequest implements
        ToCopyableBuilder<PutRepositoryPermissionsPolicyRequest.Builder, PutRepositoryPermissionsPolicyRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(PutRepositoryPermissionsPolicyRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(PutRepositoryPermissionsPolicyRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(PutRepositoryPermissionsPolicyRequest::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> POLICY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyRevision").getter(getter(PutRepositoryPermissionsPolicyRequest::policyRevision))
            .setter(setter(Builder::policyRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyRevision").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(PutRepositoryPermissionsPolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, POLICY_REVISION_FIELD, POLICY_DOCUMENT_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String policyRevision;

    private final String policyDocument;

    private PutRepositoryPermissionsPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.policyRevision = builder.policyRevision;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * The name of the domain containing the repository to set the resource policy on.
     * </p>
     * 
     * @return The name of the domain containing the repository to set the resource policy on.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository to set the resource policy on.
     * </p>
     * 
     * @return The name of the repository to set the resource policy on.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * Sets the revision of the resource policy that specifies permissions to access the repository. This revision is
     * used for optimistic locking, which prevents others from overwriting your changes to the repository's resource
     * policy.
     * </p>
     * 
     * @return Sets the revision of the resource policy that specifies permissions to access the repository. This
     *         revision is used for optimistic locking, which prevents others from overwriting your changes to the
     *         repository's resource policy.
     */
    public final String policyRevision() {
        return policyRevision;
    }

    /**
     * <p>
     * A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided
     * repository.
     * </p>
     * 
     * @return A valid displayable JSON Aspen policy string to be set as the access control resource policy on the
     *         provided repository.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevision());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRepositoryPermissionsPolicyRequest)) {
            return false;
        }
        PutRepositoryPermissionsPolicyRequest other = (PutRepositoryPermissionsPolicyRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(policyRevision(), other.policyRevision())
                && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRepositoryPermissionsPolicyRequest").add("Domain", domain())
                .add("DomainOwner", domainOwner()).add("Repository", repository()).add("PolicyRevision", policyRevision())
                .add("PolicyDocument", policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "policyRevision":
            return Optional.ofNullable(clazz.cast(policyRevision()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRepositoryPermissionsPolicyRequest, T> g) {
        return obj -> g.apply((PutRepositoryPermissionsPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRepositoryPermissionsPolicyRequest> {
        /**
         * <p>
         * The name of the domain containing the repository to set the resource policy on.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the repository to set the resource policy on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository to set the resource policy on.
         * </p>
         * 
         * @param repository
         *        The name of the repository to set the resource policy on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * Sets the revision of the resource policy that specifies permissions to access the repository. This revision
         * is used for optimistic locking, which prevents others from overwriting your changes to the repository's
         * resource policy.
         * </p>
         * 
         * @param policyRevision
         *        Sets the revision of the resource policy that specifies permissions to access the repository. This
         *        revision is used for optimistic locking, which prevents others from overwriting your changes to the
         *        repository's resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevision(String policyRevision);

        /**
         * <p>
         * A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided
         * repository.
         * </p>
         * 
         * @param policyDocument
         *        A valid displayable JSON Aspen policy string to be set as the access control resource policy on the
         *        provided repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String policyRevision;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRepositoryPermissionsPolicyRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            policyRevision(model.policyRevision);
            policyDocument(model.policyDocument);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getPolicyRevision() {
            return policyRevision;
        }

        @Override
        public final Builder policyRevision(String policyRevision) {
            this.policyRevision = policyRevision;
            return this;
        }

        public final void setPolicyRevision(String policyRevision) {
            this.policyRevision = policyRevision;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRepositoryPermissionsPolicyRequest build() {
            return new PutRepositoryPermissionsPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
