/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackageVersionDependenciesResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListPackageVersionDependenciesResponse.Builder, ListPackageVersionDependenciesResponse> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ListPackageVersionDependenciesResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListPackageVersionDependenciesResponse::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(ListPackageVersionDependenciesResponse::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ListPackageVersionDependenciesResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> VERSION_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionRevision").getter(getter(ListPackageVersionDependenciesResponse::versionRevision))
            .setter(setter(Builder::versionRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevision").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPackageVersionDependenciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PackageDependency>> DEPENDENCIES_FIELD = SdkField
            .<List<PackageDependency>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(ListPackageVersionDependenciesResponse::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD,
            PACKAGE_FIELD, VERSION_FIELD, VERSION_REVISION_FIELD, NEXT_TOKEN_FIELD, DEPENDENCIES_FIELD));

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String version;

    private final String versionRevision;

    private final String nextToken;

    private final List<PackageDependency> dependencies;

    private ListPackageVersionDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.version = builder.version;
        this.versionRevision = builder.versionRevision;
        this.nextToken = builder.nextToken;
        this.dependencies = builder.dependencies;
    }

    /**
     * <p>
     * A format that specifies the type of the package that contains the returned dependencies. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nuget</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package that contains the returned dependencies. The valid values
     *         are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>nuget</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format that specifies the type of the package that contains the returned dependencies. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nuget</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package that contains the returned dependencies. The valid values
     *         are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>nuget</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm package is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     * </p>
     * </li>
     * <li>
     * <p>
     * A NuGet package does not contain a corresponding component, so NuGet packages do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm package is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A NuGet package does not contain a corresponding component, so NuGet packages do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package that contains the returned package versions dependencies.
     * </p>
     * 
     * @return The name of the package that contains the returned package versions dependencies.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * The version of the package that is specified in the request.
     * </p>
     * 
     * @return The version of the package that is specified in the request.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The current revision associated with the package version.
     * </p>
     * 
     * @return The current revision associated with the package version.
     */
    public final String versionRevision() {
        return versionRevision;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Dependencies property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
     * <code>PackageDependency</code> </a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDependencies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The returned list of <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
     *         <code>PackageDependency</code> </a> objects.
     */
    public final List<PackageDependency> dependencies() {
        return dependencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionRevision());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionDependenciesResponse)) {
            return false;
        }
        ListPackageVersionDependenciesResponse other = (ListPackageVersionDependenciesResponse) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(packageValue(), other.packageValue()) && Objects.equals(version(), other.version())
                && Objects.equals(versionRevision(), other.versionRevision()) && Objects.equals(nextToken(), other.nextToken())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPackageVersionDependenciesResponse").add("Format", formatAsString())
                .add("Namespace", namespace()).add("Package", packageValue()).add("Version", version())
                .add("VersionRevision", versionRevision()).add("NextToken", nextToken())
                .add("Dependencies", hasDependencies() ? dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "versionRevision":
            return Optional.ofNullable(clazz.cast(versionRevision()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionDependenciesResponse, T> g) {
        return obj -> g.apply((ListPackageVersionDependenciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPackageVersionDependenciesResponse> {
        /**
         * <p>
         * A format that specifies the type of the package that contains the returned dependencies. The valid values
         * are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>nuget</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format that specifies the type of the package that contains the returned dependencies. The valid
         *        values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>nuget</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format that specifies the type of the package that contains the returned dependencies. The valid values
         * are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>nuget</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format that specifies the type of the package that contains the returned dependencies. The valid
         *        values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>nuget</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm package is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         * </p>
         * </li>
         * <li>
         * <p>
         * A NuGet package does not contain a corresponding component, so NuGet packages do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm package is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Python package does not contain a corresponding component, so Python packages do not have a
         *        namespace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A NuGet package does not contain a corresponding component, so NuGet packages do not have a namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package that contains the returned package versions dependencies.
         * </p>
         * 
         * @param packageValue
         *        The name of the package that contains the returned package versions dependencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The version of the package that is specified in the request.
         * </p>
         * 
         * @param version
         *        The version of the package that is specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The current revision associated with the package version.
         * </p>
         * 
         * @param versionRevision
         *        The current revision associated with the package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRevision(String versionRevision);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
         * <code>PackageDependency</code> </a> objects.
         * </p>
         * 
         * @param dependencies
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
         *        <code>PackageDependency</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<PackageDependency> dependencies);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
         * <code>PackageDependency</code> </a> objects.
         * </p>
         * 
         * @param dependencies
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
         *        <code>PackageDependency</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(PackageDependency... dependencies);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">
         * <code>PackageDependency</code> </a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PackageDependency>.Builder} avoiding the
         * need to create one manually via {@link List<PackageDependency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageDependency>.Builder#build()} is called immediately
         * and its result is passed to {@link #dependencies(List<PackageDependency>)}.
         * 
         * @param dependencies
         *        a consumer that will call methods on {@link List<PackageDependency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencies(List<PackageDependency>)
         */
        Builder dependencies(Consumer<PackageDependency.Builder>... dependencies);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String format;

        private String namespace;

        private String packageValue;

        private String version;

        private String versionRevision;

        private String nextToken;

        private List<PackageDependency> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionDependenciesResponse model) {
            super(model);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            version(model.version);
            versionRevision(model.versionRevision);
            nextToken(model.nextToken);
            dependencies(model.dependencies);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getVersionRevision() {
            return versionRevision;
        }

        @Override
        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
            return this;
        }

        public final void setVersionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PackageDependency.Builder> getDependencies() {
            if (dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return dependencies != null ? dependencies.stream().map(PackageDependency::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dependencies(Collection<PackageDependency> dependencies) {
            this.dependencies = PackageDependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(PackageDependency... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<PackageDependency.Builder>... dependencies) {
            dependencies(Stream.of(dependencies).map(c -> PackageDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDependencies(Collection<PackageDependency.BuilderImpl> dependencies) {
            this.dependencies = PackageDependencyListCopier.copyFromBuilder(dependencies);
        }

        @Override
        public ListPackageVersionDependenciesResponse build() {
            return new ListPackageVersionDependenciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
