/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthorizationTokenResponse extends CodeartifactResponse implements
        ToCopyableBuilder<GetAuthorizationTokenResponse.Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<String> AUTHORIZATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationToken").getter(getter(GetAuthorizationTokenResponse::authorizationToken))
            .setter(setter(Builder::authorizationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationToken").build())
            .build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiration").getter(getter(GetAuthorizationTokenResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TOKEN_FIELD,
            EXPIRATION_FIELD));

    private final String authorizationToken;

    private final Instant expiration;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationToken = builder.authorizationToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The returned authentication token.
     * </p>
     * 
     * @return The returned authentication token.
     */
    public final String authorizationToken() {
        return authorizationToken;
    }

    /**
     * <p>
     * A timestamp that specifies the date and time the authorization token expires.
     * </p>
     * 
     * @return A timestamp that specifies the date and time the authorization token expires.
     */
    public final Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizationToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse) obj;
        return Objects.equals(authorizationToken(), other.authorizationToken())
                && Objects.equals(expiration(), other.expiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAuthorizationTokenResponse").add("AuthorizationToken", authorizationToken())
                .add("Expiration", expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationToken":
            return Optional.ofNullable(clazz.cast(authorizationToken()));
        case "expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        /**
         * <p>
         * The returned authentication token.
         * </p>
         * 
         * @param authorizationToken
         *        The returned authentication token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationToken(String authorizationToken);

        /**
         * <p>
         * A timestamp that specifies the date and time the authorization token expires.
         * </p>
         * 
         * @param expiration
         *        A timestamp that specifies the date and time the authorization token expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String authorizationToken;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            authorizationToken(model.authorizationToken);
            expiration(model.expiration);
        }

        public final String getAuthorizationToken() {
            return authorizationToken;
        }

        @Override
        public final Builder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public final void setAuthorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
