/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateExternalConnectionRequest extends CodeartifactRequest implements
        ToCopyableBuilder<AssociateExternalConnectionRequest.Builder, AssociateExternalConnectionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(AssociateExternalConnectionRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(AssociateExternalConnectionRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(AssociateExternalConnectionRequest::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> EXTERNAL_CONNECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalConnection").getter(getter(AssociateExternalConnectionRequest::externalConnection))
            .setter(setter(Builder::externalConnection))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("external-connection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, EXTERNAL_CONNECTION_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String externalConnection;

    private AssociateExternalConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.externalConnection = builder.externalConnection;
    }

    /**
     * <p>
     * The name of the domain that contains the repository.
     * </p>
     * 
     * @return The name of the domain that contains the repository.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository to which the external connection is added.
     * </p>
     * 
     * @return The name of the repository to which the external connection is added.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The name of the external connection to add to the repository. The following values are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>public:npmjs</code> - for the npm public repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public:pypi</code> - for the Python Package Index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public:maven-central</code> - for Maven Central.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public:maven-googleandroid</code> - for the Google Android repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public:nuget-org</code> - for the NuGet Gallery.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the external connection to add to the repository. The following values are supported: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>public:npmjs</code> - for the npm public repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public:pypi</code> - for the Python Package Index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public:maven-central</code> - for Maven Central.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public:maven-googleandroid</code> - for the Google Android repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public:nuget-org</code> - for the NuGet Gallery.
     *         </p>
     *         </li>
     */
    public final String externalConnection() {
        return externalConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(externalConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateExternalConnectionRequest)) {
            return false;
        }
        AssociateExternalConnectionRequest other = (AssociateExternalConnectionRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository())
                && Objects.equals(externalConnection(), other.externalConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateExternalConnectionRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("ExternalConnection", externalConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "externalConnection":
            return Optional.ofNullable(clazz.cast(externalConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateExternalConnectionRequest, T> g) {
        return obj -> g.apply((AssociateExternalConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateExternalConnectionRequest> {
        /**
         * <p>
         * The name of the domain that contains the repository.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository to which the external connection is added.
         * </p>
         * 
         * @param repository
         *        The name of the repository to which the external connection is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The name of the external connection to add to the repository. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>public:npmjs</code> - for the npm public repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public:pypi</code> - for the Python Package Index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public:maven-central</code> - for Maven Central.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public:maven-googleandroid</code> - for the Google Android repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public:nuget-org</code> - for the NuGet Gallery.
         * </p>
         * </li>
         * </ul>
         * 
         * @param externalConnection
         *        The name of the external connection to add to the repository. The following values are supported: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>public:npmjs</code> - for the npm public repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public:pypi</code> - for the Python Package Index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public:maven-central</code> - for Maven Central.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public:maven-googleandroid</code> - for the Google Android repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public:nuget-org</code> - for the NuGet Gallery.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalConnection(String externalConnection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String externalConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateExternalConnectionRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            externalConnection(model.externalConnection);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getExternalConnection() {
            return externalConnection;
        }

        @Override
        public final Builder externalConnection(String externalConnection) {
            this.externalConnection = externalConnection;
            return this;
        }

        public final void setExternalConnection(String externalConnection) {
            this.externalConnection = externalConnection;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateExternalConnectionRequest build() {
            return new AssociateExternalConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
