/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;

public class DescribeLogStreamsPublisher
implements SdkPublisher<DescribeLogStreamsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeLogStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLogStreamsPublisher(CloudWatchLogsAsyncClient client, DescribeLogStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLogStreamsPublisher(CloudWatchLogsAsyncClient client, DescribeLogStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLogStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLogStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LogStream> logStreams() {
        return this.flatMapIterable(response -> response.logStreams());
    }

    private class DescribeLogStreamsResponseFetcher
    implements AsyncPageFetcher<DescribeLogStreamsResponse> {
        private DescribeLogStreamsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLogStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLogStreamsResponse> nextPage(DescribeLogStreamsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLogStreamsPublisher.this.client.describeLogStreams(DescribeLogStreamsPublisher.this.firstRequest);
            }
            return DescribeLogStreamsPublisher.this.client.describeLogStreams((DescribeLogStreamsRequest)((Object)DescribeLogStreamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

