/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliverySource;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse;

public class DescribeDeliverySourcesPublisher
implements SdkPublisher<DescribeDeliverySourcesResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeDeliverySourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDeliverySourcesPublisher(CloudWatchLogsAsyncClient client, DescribeDeliverySourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDeliverySourcesPublisher(CloudWatchLogsAsyncClient client, DescribeDeliverySourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDeliverySourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDeliverySourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeliverySource> deliverySources() {
        return this.flatMapIterable(response -> response.deliverySources());
    }

    private class DescribeDeliverySourcesResponseFetcher
    implements AsyncPageFetcher<DescribeDeliverySourcesResponse> {
        private DescribeDeliverySourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDeliverySourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDeliverySourcesResponse> nextPage(DescribeDeliverySourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDeliverySourcesPublisher.this.client.describeDeliverySources(DescribeDeliverySourcesPublisher.this.firstRequest);
            }
            return DescribeDeliverySourcesPublisher.this.client.describeDeliverySources((DescribeDeliverySourcesRequest)((Object)DescribeDeliverySourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

