/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.AggregateLogGroupSummariesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.AggregateLogGroupSummary;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAggregateLogGroupSummariesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, ListAggregateLogGroupSummariesResponse> {
    private static final SdkField<List<AggregateLogGroupSummary>> AGGREGATE_LOG_GROUP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregateLogGroupSummaries").getter(ListAggregateLogGroupSummariesResponse.getter(ListAggregateLogGroupSummariesResponse::aggregateLogGroupSummaries)).setter(ListAggregateLogGroupSummariesResponse.setter(Builder::aggregateLogGroupSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateLogGroupSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateLogGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAggregateLogGroupSummariesResponse.getter(ListAggregateLogGroupSummariesResponse::nextToken)).setter(ListAggregateLogGroupSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATE_LOG_GROUP_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAggregateLogGroupSummariesResponse.memberNameToFieldInitializer();
    private final List<AggregateLogGroupSummary> aggregateLogGroupSummaries;
    private final String nextToken;

    private ListAggregateLogGroupSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateLogGroupSummaries = builder.aggregateLogGroupSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAggregateLogGroupSummaries() {
        return this.aggregateLogGroupSummaries != null && !(this.aggregateLogGroupSummaries instanceof SdkAutoConstructList);
    }

    public final List<AggregateLogGroupSummary> aggregateLogGroupSummaries() {
        return this.aggregateLogGroupSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregateLogGroupSummaries() ? this.aggregateLogGroupSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregateLogGroupSummariesResponse)) {
            return false;
        }
        ListAggregateLogGroupSummariesResponse other = (ListAggregateLogGroupSummariesResponse)((Object)obj);
        return this.hasAggregateLogGroupSummaries() == other.hasAggregateLogGroupSummaries() && Objects.equals(this.aggregateLogGroupSummaries(), other.aggregateLogGroupSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAggregateLogGroupSummariesResponse").add("AggregateLogGroupSummaries", this.hasAggregateLogGroupSummaries() ? this.aggregateLogGroupSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregateLogGroupSummaries": {
                return Optional.ofNullable(clazz.cast(this.aggregateLogGroupSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aggregateLogGroupSummaries", AGGREGATE_LOG_GROUP_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAggregateLogGroupSummariesResponse, T> g) {
        return obj -> g.apply((ListAggregateLogGroupSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<AggregateLogGroupSummary> aggregateLogGroupSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregateLogGroupSummariesResponse model) {
            super(model);
            this.aggregateLogGroupSummaries(model.aggregateLogGroupSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AggregateLogGroupSummary.Builder> getAggregateLogGroupSummaries() {
            List<AggregateLogGroupSummary.Builder> result = AggregateLogGroupSummariesCopier.copyToBuilder(this.aggregateLogGroupSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregateLogGroupSummaries(Collection<AggregateLogGroupSummary.BuilderImpl> aggregateLogGroupSummaries) {
            this.aggregateLogGroupSummaries = AggregateLogGroupSummariesCopier.copyFromBuilder(aggregateLogGroupSummaries);
        }

        @Override
        public final Builder aggregateLogGroupSummaries(Collection<AggregateLogGroupSummary> aggregateLogGroupSummaries) {
            this.aggregateLogGroupSummaries = AggregateLogGroupSummariesCopier.copy(aggregateLogGroupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateLogGroupSummaries(AggregateLogGroupSummary ... aggregateLogGroupSummaries) {
            this.aggregateLogGroupSummaries(Arrays.asList(aggregateLogGroupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateLogGroupSummaries(Consumer<AggregateLogGroupSummary.Builder> ... aggregateLogGroupSummaries) {
            this.aggregateLogGroupSummaries(Stream.of(aggregateLogGroupSummaries).map(c -> (AggregateLogGroupSummary)((AggregateLogGroupSummary.Builder)AggregateLogGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAggregateLogGroupSummariesResponse build() {
            return new ListAggregateLogGroupSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAggregateLogGroupSummariesResponse> {
        public Builder aggregateLogGroupSummaries(Collection<AggregateLogGroupSummary> var1);

        public Builder aggregateLogGroupSummaries(AggregateLogGroupSummary ... var1);

        public Builder aggregateLogGroupSummaries(Consumer<AggregateLogGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

