/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImportTasksRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeImportTasksRequest> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(DescribeImportTasksRequest.getter(DescribeImportTasksRequest::importId)).setter(DescribeImportTasksRequest.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStatus").getter(DescribeImportTasksRequest.getter(DescribeImportTasksRequest::importStatusAsString)).setter(DescribeImportTasksRequest.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<String> IMPORT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importSourceArn").getter(DescribeImportTasksRequest.getter(DescribeImportTasksRequest::importSourceArn)).setter(DescribeImportTasksRequest.setter(Builder::importSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importSourceArn").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(DescribeImportTasksRequest.getter(DescribeImportTasksRequest::limit)).setter(DescribeImportTasksRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeImportTasksRequest.getter(DescribeImportTasksRequest::nextToken)).setter(DescribeImportTasksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORT_STATUS_FIELD, IMPORT_SOURCE_ARN_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImportTasksRequest.memberNameToFieldInitializer();
    private final String importId;
    private final String importStatus;
    private final String importSourceArn;
    private final Integer limit;
    private final String nextToken;

    private DescribeImportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.importStatus = builder.importStatus;
        this.importSourceArn = builder.importSourceArn;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final String importSourceArn() {
        return this.importSourceArn;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportTasksRequest)) {
            return false;
        }
        DescribeImportTasksRequest other = (DescribeImportTasksRequest)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.importSourceArn(), other.importSourceArn()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImportTasksRequest").add("ImportId", (Object)this.importId()).add("ImportStatus", (Object)this.importStatusAsString()).add("ImportSourceArn", (Object)this.importSourceArn()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "importSourceArn": {
                return Optional.ofNullable(clazz.cast(this.importSourceArn()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("importStatus", IMPORT_STATUS_FIELD);
        map.put("importSourceArn", IMPORT_SOURCE_ARN_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportTasksRequest, T> g) {
        return obj -> g.apply((DescribeImportTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String importId;
        private String importStatus;
        private String importSourceArn;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportTasksRequest model) {
            super(model);
            this.importId(model.importId);
            this.importStatus(model.importStatus);
            this.importSourceArn(model.importSourceArn);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getImportSourceArn() {
            return this.importSourceArn;
        }

        public final void setImportSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
        }

        @Override
        public final Builder importSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImportTasksRequest build() {
            return new DescribeImportTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImportTasksRequest> {
        public Builder importId(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder importSourceArn(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

