/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlattenedElement {
    FIRST("first"),
    LAST("last"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlattenedElement> VALUE_MAP;
    private final String value;

    private FlattenedElement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlattenedElement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlattenedElement> knownValues() {
        EnumSet<FlattenedElement> knownValues = EnumSet.allOf(FlattenedElement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlattenedElement.class, FlattenedElement::toString);
    }
}

