/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;

public class GetLogEventsPublisher
implements SdkPublisher<GetLogEventsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final GetLogEventsRequest firstRequest;
    private boolean isLastPage;

    public GetLogEventsPublisher(CloudWatchLogsAsyncClient client, GetLogEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetLogEventsPublisher(CloudWatchLogsAsyncClient client, GetLogEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
    }

    public void subscribe(Subscriber<? super GetLogEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher((AsyncPageFetcher)new GetLogEventsResponseFetcher())).build());
    }

    public final SdkPublisher<OutputLogEvent> events() {
        return this.flatMapIterable(response -> response.events());
    }

    private class GetLogEventsResponseFetcher
    implements AsyncPageFetcher<GetLogEventsResponse> {
        private Object lastToken;

        private GetLogEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetLogEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextForwardToken()) && !previousPage.nextForwardToken().equals(this.lastToken);
        }

        public CompletableFuture<GetLogEventsResponse> nextPage(GetLogEventsResponse previousPage) {
            if (previousPage == null) {
                this.lastToken = null;
                return GetLogEventsPublisher.this.client.getLogEvents(GetLogEventsPublisher.this.firstRequest);
            }
            this.lastToken = previousPage.nextForwardToken();
            return GetLogEventsPublisher.this.client.getLogEvents((GetLogEventsRequest)((Object)GetLogEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextForwardToken()).build()));
        }
    }
}

