/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;

public class DescribeLogGroupsPublisher
implements SdkPublisher<DescribeLogGroupsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeLogGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLogGroupsPublisher(CloudWatchLogsAsyncClient client, DescribeLogGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLogGroupsPublisher(CloudWatchLogsAsyncClient client, DescribeLogGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLogGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLogGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LogGroup> logGroups() {
        return this.flatMapIterable(response -> response.logGroups());
    }

    private class DescribeLogGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeLogGroupsResponse> {
        private DescribeLogGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLogGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLogGroupsResponse> nextPage(DescribeLogGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLogGroupsPublisher.this.client.describeLogGroups(DescribeLogGroupsPublisher.this.firstRequest);
            }
            return DescribeLogGroupsPublisher.this.client.describeLogGroups((DescribeLogGroupsRequest)((Object)DescribeLogGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

