/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.GroupingIdentifier;
import software.amazon.awssdk.services.cloudwatchlogs.model.GroupingIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateLogGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateLogGroupSummary> {
    private static final SdkField<Integer> LOG_GROUP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("logGroupCount").getter(AggregateLogGroupSummary.getter(AggregateLogGroupSummary::logGroupCount)).setter(AggregateLogGroupSummary.setter(Builder::logGroupCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupCount").build()}).build();
    private static final SdkField<List<GroupingIdentifier>> GROUPING_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupingIdentifiers").getter(AggregateLogGroupSummary.getter(AggregateLogGroupSummary::groupingIdentifiers)).setter(AggregateLogGroupSummary.setter(Builder::groupingIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupingIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_COUNT_FIELD, GROUPING_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregateLogGroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer logGroupCount;
    private final List<GroupingIdentifier> groupingIdentifiers;

    private AggregateLogGroupSummary(BuilderImpl builder) {
        this.logGroupCount = builder.logGroupCount;
        this.groupingIdentifiers = builder.groupingIdentifiers;
    }

    public final Integer logGroupCount() {
        return this.logGroupCount;
    }

    public final boolean hasGroupingIdentifiers() {
        return this.groupingIdentifiers != null && !(this.groupingIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<GroupingIdentifier> groupingIdentifiers() {
        return this.groupingIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupingIdentifiers() ? this.groupingIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateLogGroupSummary)) {
            return false;
        }
        AggregateLogGroupSummary other = (AggregateLogGroupSummary)obj;
        return Objects.equals(this.logGroupCount(), other.logGroupCount()) && this.hasGroupingIdentifiers() == other.hasGroupingIdentifiers() && Objects.equals(this.groupingIdentifiers(), other.groupingIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateLogGroupSummary").add("LogGroupCount", (Object)this.logGroupCount()).add("GroupingIdentifiers", this.hasGroupingIdentifiers() ? this.groupingIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupCount": {
                return Optional.ofNullable(clazz.cast(this.logGroupCount()));
            }
            case "groupingIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.groupingIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logGroupCount", LOG_GROUP_COUNT_FIELD);
        map.put("groupingIdentifiers", GROUPING_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateLogGroupSummary, T> g) {
        return obj -> g.apply((AggregateLogGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer logGroupCount;
        private List<GroupingIdentifier> groupingIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateLogGroupSummary model) {
            this.logGroupCount(model.logGroupCount);
            this.groupingIdentifiers(model.groupingIdentifiers);
        }

        public final Integer getLogGroupCount() {
            return this.logGroupCount;
        }

        public final void setLogGroupCount(Integer logGroupCount) {
            this.logGroupCount = logGroupCount;
        }

        @Override
        public final Builder logGroupCount(Integer logGroupCount) {
            this.logGroupCount = logGroupCount;
            return this;
        }

        public final List<GroupingIdentifier.Builder> getGroupingIdentifiers() {
            List<GroupingIdentifier.Builder> result = GroupingIdentifiersCopier.copyToBuilder(this.groupingIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingIdentifiers(Collection<GroupingIdentifier.BuilderImpl> groupingIdentifiers) {
            this.groupingIdentifiers = GroupingIdentifiersCopier.copyFromBuilder(groupingIdentifiers);
        }

        @Override
        public final Builder groupingIdentifiers(Collection<GroupingIdentifier> groupingIdentifiers) {
            this.groupingIdentifiers = GroupingIdentifiersCopier.copy(groupingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingIdentifiers(GroupingIdentifier ... groupingIdentifiers) {
            this.groupingIdentifiers(Arrays.asList(groupingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingIdentifiers(Consumer<GroupingIdentifier.Builder> ... groupingIdentifiers) {
            this.groupingIdentifiers(Stream.of(groupingIdentifiers).map(c -> (GroupingIdentifier)((GroupingIdentifier.Builder)GroupingIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AggregateLogGroupSummary build() {
            return new AggregateLogGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateLogGroupSummary> {
        public Builder logGroupCount(Integer var1);

        public Builder groupingIdentifiers(Collection<GroupingIdentifier> var1);

        public Builder groupingIdentifiers(GroupingIdentifier ... var1);

        public Builder groupingIdentifiers(Consumer<GroupingIdentifier.Builder> ... var1);
    }
}

