/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatistics;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelImportTaskResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, CancelImportTaskResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::importId)).setter(CancelImportTaskResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<ImportStatistics> IMPORT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importStatistics").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::importStatistics)).setter(CancelImportTaskResponse.setter(Builder::importStatistics)).constructor(ImportStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatistics").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStatus").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::importStatusAsString)).setter(CancelImportTaskResponse.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::creationTime)).setter(CancelImportTaskResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedTime").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::lastUpdatedTime)).setter(CancelImportTaskResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORT_STATISTICS_FIELD, IMPORT_STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelImportTaskResponse.memberNameToFieldInitializer();
    private final String importId;
    private final ImportStatistics importStatistics;
    private final String importStatus;
    private final Long creationTime;
    private final Long lastUpdatedTime;

    private CancelImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.importStatistics = builder.importStatistics;
        this.importStatus = builder.importStatus;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportStatistics importStatistics() {
        return this.importStatistics;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskResponse)) {
            return false;
        }
        CancelImportTaskResponse other = (CancelImportTaskResponse)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importStatistics(), other.importStatistics()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"CancelImportTaskResponse").add("ImportId", (Object)this.importId()).add("ImportStatistics", (Object)this.importStatistics()).add("ImportStatus", (Object)this.importStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importStatistics": {
                return Optional.ofNullable(clazz.cast(this.importStatistics()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("importStatistics", IMPORT_STATISTICS_FIELD);
        map.put("importStatus", IMPORT_STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelImportTaskResponse, T> g) {
        return obj -> g.apply((CancelImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String importId;
        private ImportStatistics importStatistics;
        private String importStatus;
        private Long creationTime;
        private Long lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskResponse model) {
            super(model);
            this.importId(model.importId);
            this.importStatistics(model.importStatistics);
            this.importStatus(model.importStatus);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportStatistics.Builder getImportStatistics() {
            return this.importStatistics != null ? this.importStatistics.toBuilder() : null;
        }

        public final void setImportStatistics(ImportStatistics.BuilderImpl importStatistics) {
            this.importStatistics = importStatistics != null ? importStatistics.build() : null;
        }

        @Override
        public final Builder importStatistics(ImportStatistics importStatistics) {
            this.importStatistics = importStatistics;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public CancelImportTaskResponse build() {
            return new CancelImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelImportTaskResponse> {
        public Builder importId(String var1);

        public Builder importStatistics(ImportStatistics var1);

        default public Builder importStatistics(Consumer<ImportStatistics.Builder> importStatistics) {
            return this.importStatistics((ImportStatistics)((ImportStatistics.Builder)ImportStatistics.builder().applyMutation(importStatistics)).build());
        }

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder creationTime(Long var1);

        public Builder lastUpdatedTime(Long var1);
    }
}

