/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionPojoSupplier;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.SdkPojoBuilder;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.AttachHttpMetadataResponseHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.protocol.VoidSdkResponse;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.internal.CloudWatchLogsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateSourceToS3TableIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateSourceToS3TableIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConflictException;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateImportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateImportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateScheduledQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateScheduledQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DataAlreadyAcceptedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteScheduledQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteScheduledQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeImportTaskBatchesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeImportTaskBatchesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeImportTasksResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateSourceFromS3TableIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateSourceFromS3TableIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogFieldsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogFieldsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectResponseHandler;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectResponseStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryHistoryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryHistoryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.InternalServerException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InternalStreamingException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidSequenceTokenException;
import software.amazon.awssdk.services.cloudwatchlogs.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAggregateLogGroupSummariesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAggregateLogGroupSummariesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListIntegrationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListIntegrationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListSourcesForS3TableIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListSourcesForS3TableIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MalformedQueryException;
import software.amazon.awssdk.services.cloudwatchlogs.model.OperationAbortedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogGroupDeletionProtectionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogGroupDeletionProtectionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.cloudwatchlogs.model.SessionStreamingException;
import software.amazon.awssdk.services.cloudwatchlogs.model.SessionTimeoutException;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseHandler;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ThrottlingException;
import software.amazon.awssdk.services.cloudwatchlogs.model.TooManyTagsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.UnrecognizedClientException;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateScheduledQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateScheduledQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ValidationException;
import software.amazon.awssdk.services.cloudwatchlogs.transform.AssociateKmsKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.AssociateSourceToS3TableIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CancelImportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateDeliveryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateExportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateImportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteAccountPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDataProtectionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliveryDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliveryDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliveryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliverySourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteIndexPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteQueryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteSubscriptionFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeAccountPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDeliveriesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDeliveryDestinationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDeliverySourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDestinationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeFieldIndexesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeImportTaskBatchesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeImportTasksRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeIndexPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeLogGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeMetricFiltersRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeQueryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeSubscriptionFiltersRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DisassociateKmsKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DisassociateSourceFromS3TableIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.FilterLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDataProtectionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliveryDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliveryDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliveryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliverySourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogGroupFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogObjectRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogRecordRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetScheduledQueryHistoryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListAggregateLogGroupSummariesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListAnomaliesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListLogAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListLogGroupsForQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListLogGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListScheduledQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListSourcesForS3TableIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListTagsLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutAccountPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDataProtectionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDeliveryDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDeliveryDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDeliverySourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutIndexPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutLogGroupDeletionProtectionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutQueryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutSubscriptionFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StartLiveTailRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StopQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TagLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TestMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TestTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UntagLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateAnomalyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
final class DefaultCloudWatchLogsAsyncClient
implements CloudWatchLogsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudWatchLogsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final Executor executor;

    protected DefaultCloudWatchLogsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudWatch_Logs#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executor = (Executor)clientConfiguration.option((ClientOption)SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR);
    }

    @Override
    public CompletableFuture<AssociateKmsKeyResponse> associateKmsKey(AssociateKmsKeyRequest associateKmsKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateKmsKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, associateKmsKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateKmsKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateKmsKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateKmsKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateKmsKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateKmsKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$associateKmsKey$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$associateKmsKey$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateSourceToS3TableIntegrationResponse> associateSourceToS3TableIntegration(AssociateSourceToS3TableIntegrationRequest associateSourceToS3TableIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateSourceToS3TableIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, associateSourceToS3TableIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSourceToS3TableIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSourceToS3TableIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSourceToS3TableIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateSourceToS3TableIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateSourceToS3TableIntegrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$associateSourceToS3TableIntegration$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$associateSourceToS3TableIntegration$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelExportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, cancelExportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelExportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelExportTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelExportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelExportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelExportTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$cancelExportTask$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$cancelExportTask$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelImportTaskResponse> cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelImportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, cancelImportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelImportTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelImportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelImportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelImportTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$cancelImportTask$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$cancelImportTask$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDeliveryResponse> createDelivery(CreateDeliveryRequest createDeliveryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDeliveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createDeliveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDelivery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeliveryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDelivery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDeliveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDeliveryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createDelivery$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createDelivery$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateExportTaskResponse> createExportTask(CreateExportTaskRequest createExportTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createExportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createExportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExportTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateExportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createExportTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createExportTask$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createExportTask$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateImportTaskResponse> createImportTask(CreateImportTaskRequest createImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createImportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createImportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateImportTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateImportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateImportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createImportTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createImportTask$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createImportTask$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLogAnomalyDetectorResponse> createLogAnomalyDetector(CreateLogAnomalyDetectorRequest createLogAnomalyDetectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLogAnomalyDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createLogAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogAnomalyDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogAnomalyDetectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogAnomalyDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLogAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLogAnomalyDetectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createLogAnomalyDetector$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createLogAnomalyDetector$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLogGroupResponse> createLogGroup(CreateLogGroupRequest createLogGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLogGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createLogGroup$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createLogGroup$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLogStreamResponse> createLogStream(CreateLogStreamRequest createLogStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLogStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createLogStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLogStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLogStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createLogStream$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createLogStream$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateScheduledQueryResponse> createScheduledQuery(CreateScheduledQueryRequest createScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, createScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createScheduledQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$createScheduledQuery$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$createScheduledQuery$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccountPolicyResponse> deleteAccountPolicy(DeleteAccountPolicyRequest deleteAccountPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccountPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAccountPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccountPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccountPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAccountPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAccountPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteAccountPolicy$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteAccountPolicy$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataProtectionPolicyResponse> deleteDataProtectionPolicy(DeleteDataProtectionPolicyRequest deleteDataProtectionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataProtectionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataProtectionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataProtectionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataProtectionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataProtectionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDataProtectionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDataProtectionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDataProtectionPolicy$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDataProtectionPolicy$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDeliveryResponse> deleteDelivery(DeleteDeliveryRequest deleteDeliveryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeliveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDeliveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDelivery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliveryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDelivery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDeliveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDeliveryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDelivery$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDelivery$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDeliveryDestinationResponse> deleteDeliveryDestination(DeleteDeliveryDestinationRequest deleteDeliveryDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeliveryDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDeliveryDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDeliveryDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliveryDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDeliveryDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDeliveryDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDeliveryDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDeliveryDestination$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDeliveryDestination$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDeliveryDestinationPolicyResponse> deleteDeliveryDestinationPolicy(DeleteDeliveryDestinationPolicyRequest deleteDeliveryDestinationPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeliveryDestinationPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDeliveryDestinationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDeliveryDestinationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliveryDestinationPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDeliveryDestinationPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDeliveryDestinationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDeliveryDestinationPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDeliveryDestinationPolicy$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDeliveryDestinationPolicy$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDeliverySourceResponse> deleteDeliverySource(DeleteDeliverySourceRequest deleteDeliverySourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeliverySourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDeliverySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDeliverySource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliverySourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDeliverySource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDeliverySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDeliverySourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDeliverySource$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDeliverySource$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDestination$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteDestination$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIndexPolicyResponse> deleteIndexPolicy(DeleteIndexPolicyRequest deleteIndexPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIndexPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteIndexPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIndexPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIndexPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndexPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIndexPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIndexPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteIndexPolicy$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteIndexPolicy$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIntegrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteIntegration$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteIntegration$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLogAnomalyDetectorResponse> deleteLogAnomalyDetector(DeleteLogAnomalyDetectorRequest deleteLogAnomalyDetectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLogAnomalyDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLogAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogAnomalyDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogAnomalyDetectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogAnomalyDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLogAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLogAnomalyDetectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteLogAnomalyDetector$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteLogAnomalyDetector$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLogGroupResponse> deleteLogGroup(DeleteLogGroupRequest deleteLogGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLogGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteLogGroup$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteLogGroup$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLogStreamResponse> deleteLogStream(DeleteLogStreamRequest deleteLogStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLogStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLogStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLogStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLogStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteLogStream$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteLogStream$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMetricFilterResponse> deleteMetricFilter(DeleteMetricFilterRequest deleteMetricFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMetricFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteMetricFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMetricFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMetricFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMetricFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteMetricFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMetricFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteMetricFilter$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteMetricFilter$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteQueryDefinitionResponse> deleteQueryDefinition(DeleteQueryDefinitionRequest deleteQueryDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteQueryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteQueryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQueryDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteQueryDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteQueryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteQueryDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteQueryDefinition$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteQueryDefinition$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteResourcePolicy$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteResourcePolicy$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRetentionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRetentionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRetentionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRetentionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRetentionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRetentionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteRetentionPolicy$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteRetentionPolicy$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteScheduledQueryResponse> deleteScheduledQuery(DeleteScheduledQueryRequest deleteScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteScheduledQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteScheduledQuery$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteScheduledQuery$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSubscriptionFilterResponse> deleteSubscriptionFilter(DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSubscriptionFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSubscriptionFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubscriptionFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubscriptionFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubscriptionFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSubscriptionFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSubscriptionFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteSubscriptionFilter$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteSubscriptionFilter$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTransformerResponse> deleteTransformer(DeleteTransformerRequest deleteTransformerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTransformerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTransformerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTransformer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTransformerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTransformer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTransformerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTransformerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$deleteTransformer$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$deleteTransformer$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountPoliciesResponse> describeAccountPolicies(DescribeAccountPoliciesRequest describeAccountPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeAccountPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAccountPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAccountPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeAccountPolicies$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeAccountPolicies$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationTemplatesResponse> describeConfigurationTemplates(DescribeConfigurationTemplatesRequest describeConfigurationTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigurationTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigurationTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeConfigurationTemplates$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeConfigurationTemplates$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliveriesResponse> describeDeliveries(DescribeDeliveriesRequest describeDeliveriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliveriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeDeliveriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliveries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDeliveriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDeliveriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeDeliveries$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeDeliveries$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliveryDestinationsResponse> describeDeliveryDestinations(DescribeDeliveryDestinationsRequest describeDeliveryDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliveryDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeDeliveryDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliveryDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryDestinationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDeliveryDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDeliveryDestinationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeDeliveryDestinations$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeDeliveryDestinations$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliverySourcesResponse> describeDeliverySources(DescribeDeliverySourcesRequest describeDeliverySourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliverySourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeDeliverySourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliverySources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliverySourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliverySources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDeliverySourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDeliverySourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeDeliverySources$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeDeliverySources$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDestinationsResponse> describeDestinations(DescribeDestinationsRequest describeDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDestinationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDestinationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeDestinations$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeDestinations$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeExportTasksResponse> describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExportTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeExportTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExportTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExportTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeExportTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeExportTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeExportTasks$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeExportTasks$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFieldIndexesResponse> describeFieldIndexes(DescribeFieldIndexesRequest describeFieldIndexesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFieldIndexesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeFieldIndexesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFieldIndexes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFieldIndexesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFieldIndexes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFieldIndexesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFieldIndexesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeFieldIndexes$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeFieldIndexes$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImportTaskBatchesResponse> describeImportTaskBatches(DescribeImportTaskBatchesRequest describeImportTaskBatchesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImportTaskBatchesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeImportTaskBatchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImportTaskBatches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportTaskBatchesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImportTaskBatches").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeImportTaskBatchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImportTaskBatchesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeImportTaskBatches$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeImportTaskBatches$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImportTasksResponse> describeImportTasks(DescribeImportTasksRequest describeImportTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImportTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeImportTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImportTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImportTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeImportTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImportTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeImportTasks$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeImportTasks$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIndexPoliciesResponse> describeIndexPolicies(DescribeIndexPoliciesRequest describeIndexPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIndexPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeIndexPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIndexPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIndexPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIndexPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeIndexPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeIndexPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeIndexPolicies$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeIndexPolicies$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLogGroupsResponse> describeLogGroups(DescribeLogGroupsRequest describeLogGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLogGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeLogGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLogGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLogGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLogGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLogGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLogGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeLogGroups$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeLogGroups$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLogStreamsResponse> describeLogStreams(DescribeLogStreamsRequest describeLogStreamsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLogStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeLogStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLogStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLogStreamsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLogStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLogStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLogStreamsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeLogStreams$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeLogStreams$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMetricFiltersResponse> describeMetricFilters(DescribeMetricFiltersRequest describeMetricFiltersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetricFiltersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeMetricFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetricFilters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetricFiltersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricFilters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMetricFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMetricFiltersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeMetricFilters$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeMetricFilters$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeQueriesResponse> describeQueries(DescribeQueriesRequest describeQueriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQueries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeQueriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeQueries$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeQueries$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeQueryDefinitionsResponse> describeQueryDefinitions(DescribeQueryDefinitionsRequest describeQueryDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeQueryDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeQueryDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQueryDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueryDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQueryDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeQueryDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeQueryDefinitionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeQueryDefinitions$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeQueryDefinitions$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourcePoliciesResponse> describeResourcePolicies(DescribeResourcePoliciesRequest describeResourcePoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourcePoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourcePoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeResourcePolicies$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeResourcePolicies$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSubscriptionFiltersResponse> describeSubscriptionFilters(DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSubscriptionFiltersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, describeSubscriptionFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSubscriptionFilters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSubscriptionFiltersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSubscriptionFilters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSubscriptionFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSubscriptionFiltersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$describeSubscriptionFilters$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$describeSubscriptionFilters$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateKmsKeyResponse> disassociateKmsKey(DisassociateKmsKeyRequest disassociateKmsKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateKmsKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateKmsKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateKmsKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateKmsKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateKmsKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateKmsKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateKmsKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$disassociateKmsKey$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$disassociateKmsKey$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateSourceFromS3TableIntegrationResponse> disassociateSourceFromS3TableIntegration(DisassociateSourceFromS3TableIntegrationRequest disassociateSourceFromS3TableIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateSourceFromS3TableIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateSourceFromS3TableIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSourceFromS3TableIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSourceFromS3TableIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSourceFromS3TableIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateSourceFromS3TableIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateSourceFromS3TableIntegrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$disassociateSourceFromS3TableIntegration$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$disassociateSourceFromS3TableIntegration$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<FilterLogEventsResponse> filterLogEvents(FilterLogEventsRequest filterLogEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)filterLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, filterLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FilterLogEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FilterLogEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("FilterLogEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new FilterLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)filterLogEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$filterLogEvents$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$filterLogEvents$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataProtectionPolicyResponse> getDataProtectionPolicy(GetDataProtectionPolicyRequest getDataProtectionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataProtectionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getDataProtectionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataProtectionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataProtectionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataProtectionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataProtectionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataProtectionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getDataProtectionPolicy$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getDataProtectionPolicy$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeliveryResponse> getDelivery(GetDeliveryRequest getDeliveryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getDeliveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDelivery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliveryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDelivery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDeliveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDeliveryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getDelivery$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getDelivery$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeliveryDestinationResponse> getDeliveryDestination(GetDeliveryDestinationRequest getDeliveryDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliveryDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getDeliveryDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliveryDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliveryDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliveryDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDeliveryDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDeliveryDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getDeliveryDestination$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getDeliveryDestination$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeliveryDestinationPolicyResponse> getDeliveryDestinationPolicy(GetDeliveryDestinationPolicyRequest getDeliveryDestinationPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliveryDestinationPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getDeliveryDestinationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliveryDestinationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliveryDestinationPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliveryDestinationPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDeliveryDestinationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDeliveryDestinationPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getDeliveryDestinationPolicy$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getDeliveryDestinationPolicy$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeliverySourceResponse> getDeliverySource(GetDeliverySourceRequest getDeliverySourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliverySourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getDeliverySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverySource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverySourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverySource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDeliverySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDeliverySourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getDeliverySource$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getDeliverySource$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIntegrationResponse> getIntegration(GetIntegrationRequest getIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getIntegrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getIntegration$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getIntegration$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLogAnomalyDetectorResponse> getLogAnomalyDetector(GetLogAnomalyDetectorRequest getLogAnomalyDetectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLogAnomalyDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getLogAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogAnomalyDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogAnomalyDetectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogAnomalyDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLogAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLogAnomalyDetectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getLogAnomalyDetector$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getLogAnomalyDetector$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLogEventsResponse> getLogEvents(GetLogEventsRequest getLogEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLogEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getLogEvents$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getLogEvents$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLogFieldsResponse> getLogFields(GetLogFieldsRequest getLogFieldsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLogFieldsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getLogFieldsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogFields");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogFieldsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogFields").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLogFieldsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLogFieldsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getLogFields$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getLogFields$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLogGroupFieldsResponse> getLogGroupFields(GetLogGroupFieldsRequest getLogGroupFieldsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLogGroupFieldsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getLogGroupFieldsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogGroupFields");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogGroupFieldsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogGroupFields").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLogGroupFieldsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLogGroupFieldsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getLogGroupFields$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getLogGroupFields$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<Void> getLogObject(GetLogObjectRequest getLogObjectRequest, GetLogObjectResponseHandler asyncResponseHandler) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLogObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getLogObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            AttachHttpMetadataResponseHandler responseHandler = new AttachHttpMetadataResponseHandler(this.protocolFactory.createResponseHandler(operationMetadata, GetLogObjectResponse::builder));
            HttpResponseHandler voidResponseHandler = this.protocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(false).hasStreamingSuccessResponse(true).build(), VoidSdkResponse::builder);
            HttpResponseHandler eventResponseHandler = this.protocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(true).hasStreamingSuccessResponse(false).build(), (Function)EventStreamTaggedUnionPojoSupplier.builder().putSdkPojoSupplier("fields", GetLogObjectResponseStream::fieldsBuilder).defaultSdkPojoSupplier(() -> new SdkPojoBuilder((SdkPojo)GetLogObjectResponseStream.UNKNOWN)).build());
            Function<String, Optional<ExceptionMetadata>> eventstreamExceptionMetadataMapper = errorCode -> {
                switch (errorCode) {
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorEventResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, eventstreamExceptionMetadataMapper);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "streaming-";
            String resolvedHostExpression = "streaming-";
            CompletableFuture future = new CompletableFuture();
            EventStreamAsyncResponseTransformer asyncResponseTransformer = EventStreamAsyncResponseTransformer.builder().eventStreamResponseHandler((EventStreamResponseHandler)asyncResponseHandler).eventResponseHandler(eventResponseHandler).initialResponseHandler((HttpResponseHandler)responseHandler).exceptionResponseHandler(errorEventResponseHandler).future(future).executor(this.executor).serviceName(this.serviceName()).build();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLogObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(voidResponseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getLogObjectRequest), (AsyncResponseTransformer)asyncResponseTransformer);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getLogObject$248(asyncResponseHandler, future, metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return CompletableFutureUtils.forwardExceptionTo(future, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseHandler.exceptionOccurred(t));
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getLogObject$250((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLogRecordResponse> getLogRecord(GetLogRecordRequest getLogRecordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLogRecordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getLogRecordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogRecord");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogRecordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogRecord").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLogRecordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLogRecordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getLogRecord$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getLogRecord$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueryResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getQueryResultsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getQueryResults$257(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getQueryResults$258((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetScheduledQueryResponse> getScheduledQuery(GetScheduledQueryRequest getScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getScheduledQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getScheduledQuery$261(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getScheduledQuery$262((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetScheduledQueryHistoryResponse> getScheduledQueryHistory(GetScheduledQueryHistoryRequest getScheduledQueryHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getScheduledQueryHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getScheduledQueryHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetScheduledQueryHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetScheduledQueryHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetScheduledQueryHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetScheduledQueryHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getScheduledQueryHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getScheduledQueryHistory$265(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getScheduledQueryHistory$266((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTransformerResponse> getTransformer(GetTransformerRequest getTransformerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTransformerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, getTransformerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTransformer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTransformerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTransformer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTransformerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTransformerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$getTransformer$269(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$getTransformer$270((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAggregateLogGroupSummariesResponse> listAggregateLogGroupSummaries(ListAggregateLogGroupSummariesRequest listAggregateLogGroupSummariesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAggregateLogGroupSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listAggregateLogGroupSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAggregateLogGroupSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAggregateLogGroupSummariesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAggregateLogGroupSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAggregateLogGroupSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAggregateLogGroupSummariesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listAggregateLogGroupSummaries$273(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listAggregateLogGroupSummaries$274((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAnomaliesResponse> listAnomalies(ListAnomaliesRequest listAnomaliesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAnomaliesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listAnomaliesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomalies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomaliesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomalies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAnomaliesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAnomaliesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listAnomalies$277(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listAnomalies$278((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIntegrationsResponse> listIntegrations(ListIntegrationsRequest listIntegrationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIntegrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listIntegrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIntegrations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIntegrationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIntegrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListIntegrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIntegrationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listIntegrations$281(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listIntegrations$282((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLogAnomalyDetectorsResponse> listLogAnomalyDetectors(ListLogAnomalyDetectorsRequest listLogAnomalyDetectorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLogAnomalyDetectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listLogAnomalyDetectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogAnomalyDetectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogAnomalyDetectorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogAnomalyDetectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLogAnomalyDetectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLogAnomalyDetectorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listLogAnomalyDetectors$285(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listLogAnomalyDetectors$286((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLogGroupsResponse> listLogGroups(ListLogGroupsRequest listLogGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLogGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listLogGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLogGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLogGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listLogGroups$289(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listLogGroups$290((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLogGroupsForQueryResponse> listLogGroupsForQuery(ListLogGroupsForQueryRequest listLogGroupsForQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLogGroupsForQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listLogGroupsForQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogGroupsForQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogGroupsForQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogGroupsForQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLogGroupsForQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLogGroupsForQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listLogGroupsForQuery$293(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listLogGroupsForQuery$294((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListScheduledQueriesResponse> listScheduledQueries(ListScheduledQueriesRequest listScheduledQueriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listScheduledQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listScheduledQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScheduledQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScheduledQueriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScheduledQueries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListScheduledQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listScheduledQueriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listScheduledQueries$297(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listScheduledQueries$298((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSourcesForS3TableIntegrationResponse> listSourcesForS3TableIntegration(ListSourcesForS3TableIntegrationRequest listSourcesForS3TableIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSourcesForS3TableIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listSourcesForS3TableIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourcesForS3TableIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourcesForS3TableIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourcesForS3TableIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSourcesForS3TableIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSourcesForS3TableIntegrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listSourcesForS3TableIntegration$301(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listSourcesForS3TableIntegration$302((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listTagsForResource$305(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listTagsForResource$306((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsLogGroupResponse> listTagsLogGroup(ListTagsLogGroupRequest listTagsLogGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsLogGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsLogGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsLogGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsLogGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$listTagsLogGroup$309(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$listTagsLogGroup$310((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccountPolicyResponse> putAccountPolicy(PutAccountPolicyRequest putAccountPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putAccountPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAccountPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccountPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putAccountPolicy$313(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putAccountPolicy$314((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDataProtectionPolicyResponse> putDataProtectionPolicy(PutDataProtectionPolicyRequest putDataProtectionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDataProtectionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putDataProtectionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDataProtectionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDataProtectionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDataProtectionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDataProtectionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDataProtectionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putDataProtectionPolicy$317(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putDataProtectionPolicy$318((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDeliveryDestinationResponse> putDeliveryDestination(PutDeliveryDestinationRequest putDeliveryDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDeliveryDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putDeliveryDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDeliveryDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliveryDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliveryDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDeliveryDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDeliveryDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putDeliveryDestination$321(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putDeliveryDestination$322((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDeliveryDestinationPolicyResponse> putDeliveryDestinationPolicy(PutDeliveryDestinationPolicyRequest putDeliveryDestinationPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDeliveryDestinationPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putDeliveryDestinationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDeliveryDestinationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliveryDestinationPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliveryDestinationPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDeliveryDestinationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDeliveryDestinationPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putDeliveryDestinationPolicy$325(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putDeliveryDestinationPolicy$326((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDeliverySourceResponse> putDeliverySource(PutDeliverySourceRequest putDeliverySourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDeliverySourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putDeliverySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDeliverySource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliverySourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliverySource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDeliverySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDeliverySourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putDeliverySource$329(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putDeliverySource$330((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDestinationResponse> putDestination(PutDestinationRequest putDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putDestination$333(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putDestination$334((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDestinationPolicyResponse> putDestinationPolicy(PutDestinationPolicyRequest putDestinationPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDestinationPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putDestinationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDestinationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDestinationPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDestinationPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDestinationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDestinationPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putDestinationPolicy$337(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putDestinationPolicy$338((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutIndexPolicyResponse> putIndexPolicy(PutIndexPolicyRequest putIndexPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putIndexPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putIndexPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutIndexPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutIndexPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutIndexPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutIndexPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putIndexPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putIndexPolicy$341(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putIndexPolicy$342((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutIntegrationResponse> putIntegration(PutIntegrationRequest putIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putIntegrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putIntegration$345(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putIntegration$346((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutLogEventsResponse> putLogEvents(PutLogEventsRequest putLogEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLogEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLogEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLogEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putLogEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putLogEvents$349(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putLogEvents$350((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutLogGroupDeletionProtectionResponse> putLogGroupDeletionProtection(PutLogGroupDeletionProtectionRequest putLogGroupDeletionProtectionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLogGroupDeletionProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putLogGroupDeletionProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLogGroupDeletionProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLogGroupDeletionProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLogGroupDeletionProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutLogGroupDeletionProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putLogGroupDeletionProtectionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putLogGroupDeletionProtection$353(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putLogGroupDeletionProtection$354((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMetricFilterResponse> putMetricFilter(PutMetricFilterRequest putMetricFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putMetricFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putMetricFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMetricFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutMetricFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putMetricFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putMetricFilter$357(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putMetricFilter$358((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutQueryDefinitionResponse> putQueryDefinition(PutQueryDefinitionRequest putQueryDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putQueryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putQueryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutQueryDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutQueryDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutQueryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutQueryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putQueryDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putQueryDefinition$361(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putQueryDefinition$362((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putResourcePolicy$365(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putResourcePolicy$366((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRetentionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putRetentionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRetentionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRetentionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutRetentionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRetentionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putRetentionPolicy$369(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putRetentionPolicy$370((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutSubscriptionFilterResponse> putSubscriptionFilter(PutSubscriptionFilterRequest putSubscriptionFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putSubscriptionFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putSubscriptionFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSubscriptionFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSubscriptionFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSubscriptionFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutSubscriptionFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putSubscriptionFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putSubscriptionFilter$373(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putSubscriptionFilter$374((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutTransformerResponse> putTransformer(PutTransformerRequest putTransformerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTransformerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, putTransformerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTransformer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTransformerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTransformer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutTransformerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putTransformerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$putTransformer$377(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$putTransformer$378((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<Void> startLiveTail(StartLiveTailRequest startLiveTailRequest, StartLiveTailResponseHandler asyncResponseHandler) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startLiveTailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, startLiveTailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLiveTail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            AttachHttpMetadataResponseHandler responseHandler = new AttachHttpMetadataResponseHandler(this.protocolFactory.createResponseHandler(operationMetadata, StartLiveTailResponse::builder));
            HttpResponseHandler voidResponseHandler = this.protocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(false).hasStreamingSuccessResponse(true).build(), VoidSdkResponse::builder);
            HttpResponseHandler eventResponseHandler = this.protocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(true).hasStreamingSuccessResponse(false).build(), (Function)EventStreamTaggedUnionPojoSupplier.builder().putSdkPojoSupplier("sessionStart", StartLiveTailResponseStream::sessionStartBuilder).putSdkPojoSupplier("sessionUpdate", StartLiveTailResponseStream::sessionUpdateBuilder).defaultSdkPojoSupplier(() -> new SdkPojoBuilder((SdkPojo)StartLiveTailResponseStream.UNKNOWN)).build());
            Function<String, Optional<ExceptionMetadata>> eventstreamExceptionMetadataMapper = errorCode -> {
                switch (errorCode) {
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorEventResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, eventstreamExceptionMetadataMapper);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "streaming-";
            String resolvedHostExpression = "streaming-";
            CompletableFuture future = new CompletableFuture();
            EventStreamAsyncResponseTransformer asyncResponseTransformer = EventStreamAsyncResponseTransformer.builder().eventStreamResponseHandler((EventStreamResponseHandler)asyncResponseHandler).eventResponseHandler(eventResponseHandler).initialResponseHandler((HttpResponseHandler)responseHandler).exceptionResponseHandler(errorEventResponseHandler).future(future).executor(this.executor).serviceName(this.serviceName()).build();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLiveTail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartLiveTailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(voidResponseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startLiveTailRequest), (AsyncResponseTransformer)asyncResponseTransformer);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$startLiveTail$383(asyncResponseHandler, future, metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return CompletableFutureUtils.forwardExceptionTo(future, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseHandler.exceptionOccurred(t));
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$startLiveTail$385((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartQueryResponse> startQuery(StartQueryRequest startQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, startQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$startQuery$388(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$startQuery$389((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopQueryResponse> stopQuery(StopQueryRequest stopQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, stopQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$stopQuery$392(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$stopQuery$393((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagLogGroupResponse> tagLogGroup(TagLogGroupRequest tagLogGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, tagLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagLogGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagLogGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagLogGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagLogGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$tagLogGroup$396(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$tagLogGroup$397((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$tagResource$400(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$tagResource$401((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestMetricFilterResponse> testMetricFilter(TestMetricFilterRequest testMetricFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testMetricFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, testMetricFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestMetricFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestMetricFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestMetricFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TestMetricFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testMetricFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$testMetricFilter$404(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$testMetricFilter$405((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestTransformerResponse> testTransformer(TestTransformerRequest testTransformerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testTransformerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, testTransformerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestTransformer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestTransformerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestTransformer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TestTransformerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testTransformerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$testTransformer$408(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$testTransformer$409((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagLogGroupResponse> untagLogGroup(UntagLogGroupRequest untagLogGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, untagLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagLogGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagLogGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagLogGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagLogGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$untagLogGroup$412(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$untagLogGroup$413((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$untagResource$416(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$untagResource$417((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAnomalyResponse> updateAnomaly(UpdateAnomalyRequest updateAnomalyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAnomalyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, updateAnomalyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomaly");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomaly").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAnomalyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAnomalyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$updateAnomaly$420(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$updateAnomaly$421((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDeliveryConfigurationResponse> updateDeliveryConfiguration(UpdateDeliveryConfigurationRequest updateDeliveryConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDeliveryConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, updateDeliveryConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDeliveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeliveryConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DataAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
                    }
                    case "InvalidSequenceTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InternalStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalStreamingException::builder).build());
                    }
                    case "OperationAbortedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationAbortedException::builder).build());
                    }
                    case "SessionTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionTimeoutException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "UnrecognizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MalformedQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedQueryException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "SessionStreamingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionStreamingException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDeliveryConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDeliveryConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDeliveryConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchLogsAsyncClient.lambda$updateDeliveryConfiguration$424(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsAsyncClient.lambda$updateDeliveryConfiguration$425((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLogAnomalyDetectorResponse> updateLogAnomalyDetector(UpdateLogAnomalyDetectorRequest updateLogAnomalyDetectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLogAnomalyDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsAsyncClient.resolveMetricPublishers(clientConfiguration, updateLogAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLogAnomalyDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLogAnomalyDetectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                   