/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntityRejectionErrorType {
    INVALID_ENTITY("InvalidEntity"),
    INVALID_TYPE_VALUE("InvalidTypeValue"),
    INVALID_KEY_ATTRIBUTES("InvalidKeyAttributes"),
    INVALID_ATTRIBUTES("InvalidAttributes"),
    ENTITY_SIZE_TOO_LARGE("EntitySizeTooLarge"),
    UNSUPPORTED_LOG_GROUP_TYPE("UnsupportedLogGroupType"),
    MISSING_REQUIRED_FIELDS("MissingRequiredFields"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntityRejectionErrorType> VALUE_MAP;
    private final String value;

    private EntityRejectionErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityRejectionErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityRejectionErrorType> knownValues() {
        EnumSet<EntityRejectionErrorType> knownValues = EnumSet.allOf(EntityRejectionErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntityRejectionErrorType.class, EntityRejectionErrorType::toString);
    }
}

