/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchResourceConfig.Builder, OpenSearchResourceConfig> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(OpenSearchResourceConfig::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> DATA_SOURCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceRoleArn").getter(getter(OpenSearchResourceConfig::dataSourceRoleArn))
            .setter(setter(Builder::dataSourceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceRoleArn").build()).build();

    private static final SdkField<List<String>> DASHBOARD_VIEWER_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dashboardViewerPrincipals")
            .getter(getter(OpenSearchResourceConfig::dashboardViewerPrincipals))
            .setter(setter(Builder::dashboardViewerPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardViewerPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(OpenSearchResourceConfig::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<Integer> RETENTION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionDays").getter(getter(OpenSearchResourceConfig::retentionDays))
            .setter(setter(Builder::retentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD,
            DATA_SOURCE_ROLE_ARN_FIELD, DASHBOARD_VIEWER_PRINCIPALS_FIELD, APPLICATION_ARN_FIELD, RETENTION_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyArn;

    private final String dataSourceRoleArn;

    private final List<String> dashboardViewerPrincipals;

    private final String applicationArn;

    private final Integer retentionDays;

    private OpenSearchResourceConfig(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.dataSourceRoleArn = builder.dataSourceRoleArn;
        this.dashboardViewerPrincipals = builder.dashboardViewerPrincipals;
        this.applicationArn = builder.applicationArn;
        this.retentionDays = builder.retentionDays;
    }

    /**
     * <p>
     * To have the vended dashboard data encrypted with KMS instead of the CloudWatch Logs default encryption method,
     * specify the ARN of the KMS key that you want to use.
     * </p>
     * 
     * @return To have the vended dashboard data encrypted with KMS instead of the CloudWatch Logs default encryption
     *         method, specify the ARN of the KMS key that you want to use.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must have the
     * permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more
     * information about the permissions needed, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html">Permissions
     * that the integration needs</a> in the CloudWatch Logs User Guide.
     * </p>
     * 
     * @return Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must
     *         have the permissions necessary to access the OpenSearch Service collection to be able to create the
     *         dashboards. For more information about the permissions needed, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html"
     *         >Permissions that the integration needs</a> in the CloudWatch Logs User Guide.
     */
    public final String dataSourceRoleArn() {
        return dataSourceRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashboardViewerPrincipals property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDashboardViewerPrincipals() {
        return dashboardViewerPrincipals != null && !(dashboardViewerPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
     * </p>
     * <important>
     * <p>
     * In addition to specifying these users here, you must also grant them the
     * <b>CloudWatchOpenSearchDashboardAccess</b> IAM policy. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html">IAM policies
     * for users</a>.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboardViewerPrincipals} method.
     * </p>
     * 
     * @return Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the
     *         dashboards.</p> <important>
     *         <p>
     *         In addition to specifying these users here, you must also grant them the
     *         <b>CloudWatchOpenSearchDashboardAccess</b> IAM policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html">IAM
     *         policies for users</a>.
     *         </p>
     */
    public final List<String> dashboardViewerPrincipals() {
        return dashboardViewerPrincipals;
    }

    /**
     * <p>
     * If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service,
     * specify it here. If you omit this, a new application will be created.
     * </p>
     * 
     * @return If you want to use an existing OpenSearch Service application for your integration with OpenSearch
     *         Service, specify it here. If you omit this, a new application will be created.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the
     * dashboard refers to. This also sets the maximum time period that you can choose when viewing data in the
     * dashboard. Choosing a longer time frame will incur additional costs.
     * </p>
     * 
     * @return Specify how many days that you want the data derived by OpenSearch Service to be retained in the index
     *         that the dashboard refers to. This also sets the maximum time period that you can choose when viewing
     *         data in the dashboard. Choosing a longer time frame will incur additional costs.
     */
    public final Integer retentionDays() {
        return retentionDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboardViewerPrincipals() ? dashboardViewerPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(retentionDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchResourceConfig)) {
            return false;
        }
        OpenSearchResourceConfig other = (OpenSearchResourceConfig) obj;
        return Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(dataSourceRoleArn(), other.dataSourceRoleArn())
                && hasDashboardViewerPrincipals() == other.hasDashboardViewerPrincipals()
                && Objects.equals(dashboardViewerPrincipals(), other.dashboardViewerPrincipals())
                && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(retentionDays(), other.retentionDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchResourceConfig").add("KmsKeyArn", kmsKeyArn())
                .add("DataSourceRoleArn", dataSourceRoleArn())
                .add("DashboardViewerPrincipals", hasDashboardViewerPrincipals() ? dashboardViewerPrincipals() : null)
                .add("ApplicationArn", applicationArn()).add("RetentionDays", retentionDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "dataSourceRoleArn":
            return Optional.ofNullable(clazz.cast(dataSourceRoleArn()));
        case "dashboardViewerPrincipals":
            return Optional.ofNullable(clazz.cast(dashboardViewerPrincipals()));
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "retentionDays":
            return Optional.ofNullable(clazz.cast(retentionDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("dataSourceRoleArn", DATA_SOURCE_ROLE_ARN_FIELD);
        map.put("dashboardViewerPrincipals", DASHBOARD_VIEWER_PRINCIPALS_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("retentionDays", RETENTION_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchResourceConfig, T> g) {
        return obj -> g.apply((OpenSearchResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchResourceConfig> {
        /**
         * <p>
         * To have the vended dashboard data encrypted with KMS instead of the CloudWatch Logs default encryption
         * method, specify the ARN of the KMS key that you want to use.
         * </p>
         * 
         * @param kmsKeyArn
         *        To have the vended dashboard data encrypted with KMS instead of the CloudWatch Logs default encryption
         *        method, specify the ARN of the KMS key that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must have
         * the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards.
         * For more information about the permissions needed, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html"
         * >Permissions that the integration needs</a> in the CloudWatch Logs User Guide.
         * </p>
         * 
         * @param dataSourceRoleArn
         *        Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must
         *        have the permissions necessary to access the OpenSearch Service collection to be able to create the
         *        dashboards. For more information about the permissions needed, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html"
         *        >Permissions that the integration needs</a> in the CloudWatch Logs User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceRoleArn(String dataSourceRoleArn);

        /**
         * <p>
         * Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
         * </p>
         * <important>
         * <p>
         * In addition to specifying these users here, you must also grant them the
         * <b>CloudWatchOpenSearchDashboardAccess</b> IAM policy. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html">IAM
         * policies for users</a>.
         * </p>
         * </important>
         * 
         * @param dashboardViewerPrincipals
         *        Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the
         *        dashboards.</p> <important>
         *        <p>
         *        In addition to specifying these users here, you must also grant them the
         *        <b>CloudWatchOpenSearchDashboardAccess</b> IAM policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html"
         *        >IAM policies for users</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardViewerPrincipals(Collection<String> dashboardViewerPrincipals);

        /**
         * <p>
         * Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
         * </p>
         * <important>
         * <p>
         * In addition to specifying these users here, you must also grant them the
         * <b>CloudWatchOpenSearchDashboardAccess</b> IAM policy. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html">IAM
         * policies for users</a>.
         * </p>
         * </important>
         * 
         * @param dashboardViewerPrincipals
         *        Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the
         *        dashboards.</p> <important>
         *        <p>
         *        In addition to specifying these users here, you must also grant them the
         *        <b>CloudWatchOpenSearchDashboardAccess</b> IAM policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html"
         *        >IAM policies for users</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardViewerPrincipals(String... dashboardViewerPrincipals);

        /**
         * <p>
         * If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service,
         * specify it here. If you omit this, a new application will be created.
         * </p>
         * 
         * @param applicationArn
         *        If you want to use an existing OpenSearch Service application for your integration with OpenSearch
         *        Service, specify it here. If you omit this, a new application will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that
         * the dashboard refers to. This also sets the maximum time period that you can choose when viewing data in the
         * dashboard. Choosing a longer time frame will incur additional costs.
         * </p>
         * 
         * @param retentionDays
         *        Specify how many days that you want the data derived by OpenSearch Service to be retained in the index
         *        that the dashboard refers to. This also sets the maximum time period that you can choose when viewing
         *        data in the dashboard. Choosing a longer time frame will incur additional costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionDays(Integer retentionDays);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyArn;

        private String dataSourceRoleArn;

        private List<String> dashboardViewerPrincipals = DefaultSdkAutoConstructList.getInstance();

        private String applicationArn;

        private Integer retentionDays;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchResourceConfig model) {
            kmsKeyArn(model.kmsKeyArn);
            dataSourceRoleArn(model.dataSourceRoleArn);
            dashboardViewerPrincipals(model.dashboardViewerPrincipals);
            applicationArn(model.applicationArn);
            retentionDays(model.retentionDays);
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getDataSourceRoleArn() {
            return dataSourceRoleArn;
        }

        public final void setDataSourceRoleArn(String dataSourceRoleArn) {
            this.dataSourceRoleArn = dataSourceRoleArn;
        }

        @Override
        public final Builder dataSourceRoleArn(String dataSourceRoleArn) {
            this.dataSourceRoleArn = dataSourceRoleArn;
            return this;
        }

        public final Collection<String> getDashboardViewerPrincipals() {
            if (dashboardViewerPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return dashboardViewerPrincipals;
        }

        public final void setDashboardViewerPrincipals(Collection<String> dashboardViewerPrincipals) {
            this.dashboardViewerPrincipals = DashboardViewerPrincipalsCopier.copy(dashboardViewerPrincipals);
        }

        @Override
        public final Builder dashboardViewerPrincipals(Collection<String> dashboardViewerPrincipals) {
            this.dashboardViewerPrincipals = DashboardViewerPrincipalsCopier.copy(dashboardViewerPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardViewerPrincipals(String... dashboardViewerPrincipals) {
            dashboardViewerPrincipals(Arrays.asList(dashboardViewerPrincipals));
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final Integer getRetentionDays() {
            return retentionDays;
        }

        public final void setRetentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
        }

        @Override
        public final Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        @Override
        public OpenSearchResourceConfig build() {
            return new OpenSearchResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
