/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This processor takes a list of objects that contain key fields, and converts them into a map of target keys.
 * </p>
 * <p>
 * For more information about this processor including examples, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-listToMap"
 * > listToMap</a> in the <i>CloudWatch Logs User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListToMap implements SdkPojo, Serializable, ToCopyableBuilder<ListToMap.Builder, ListToMap> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ListToMap::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(ListToMap::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueKey").getter(getter(ListToMap::valueKey)).setter(setter(Builder::valueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueKey").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(ListToMap::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<Boolean> FLATTEN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("flatten").getter(getter(ListToMap::flatten)).setter(setter(Builder::flatten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flatten").build()).build();

    private static final SdkField<String> FLATTENED_ELEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flattenedElement").getter(getter(ListToMap::flattenedElementAsString))
            .setter(setter(Builder::flattenedElement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flattenedElement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, KEY_FIELD,
            VALUE_KEY_FIELD, TARGET_FIELD, FLATTEN_FIELD, FLATTENED_ELEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String key;

    private final String valueKey;

    private final String target;

    private final Boolean flatten;

    private final String flattenedElement;

    private ListToMap(BuilderImpl builder) {
        this.source = builder.source;
        this.key = builder.key;
        this.valueKey = builder.valueKey;
        this.target = builder.target;
        this.flatten = builder.flatten;
        this.flattenedElement = builder.flattenedElement;
    }

    /**
     * <p>
     * The key in the log event that has a list of objects that will be converted to a map.
     * </p>
     * 
     * @return The key in the log event that has a list of objects that will be converted to a map.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The key of the field to be extracted as keys in the generated map
     * </p>
     * 
     * @return The key of the field to be extracted as keys in the generated map
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * If this is specified, the values that you specify in this parameter will be extracted from the
     * <code>source</code> objects and put into the values of the generated map. Otherwise, original objects in the
     * source list will be put into the values of the generated map.
     * </p>
     * 
     * @return If this is specified, the values that you specify in this parameter will be extracted from the
     *         <code>source</code> objects and put into the values of the generated map. Otherwise, original objects in
     *         the source list will be put into the values of the generated map.
     */
    public final String valueKey() {
        return valueKey;
    }

    /**
     * <p>
     * The key of the field that will hold the generated map
     * </p>
     * 
     * @return The key of the field that will hold the generated map
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * A Boolean value to indicate whether the list will be flattened into single items. Specify <code>true</code> to
     * flatten the list. The default is <code>false</code>
     * </p>
     * 
     * @return A Boolean value to indicate whether the list will be flattened into single items. Specify
     *         <code>true</code> to flatten the list. The default is <code>false</code>
     */
    public final Boolean flatten() {
        return flatten;
    }

    /**
     * <p>
     * If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify which element,
     * <code>first</code> or <code>last</code>, to keep.
     * </p>
     * <p>
     * You must specify this parameter if <code>flatten</code> is <code>true</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flattenedElement}
     * will return {@link FlattenedElement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #flattenedElementAsString}.
     * </p>
     * 
     * @return If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify which
     *         element, <code>first</code> or <code>last</code>, to keep. </p>
     *         <p>
     *         You must specify this parameter if <code>flatten</code> is <code>true</code>
     * @see FlattenedElement
     */
    public final FlattenedElement flattenedElement() {
        return FlattenedElement.fromValue(flattenedElement);
    }

    /**
     * <p>
     * If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify which element,
     * <code>first</code> or <code>last</code>, to keep.
     * </p>
     * <p>
     * You must specify this parameter if <code>flatten</code> is <code>true</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flattenedElement}
     * will return {@link FlattenedElement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #flattenedElementAsString}.
     * </p>
     * 
     * @return If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify which
     *         element, <code>first</code> or <code>last</code>, to keep. </p>
     *         <p>
     *         You must specify this parameter if <code>flatten</code> is <code>true</code>
     * @see FlattenedElement
     */
    public final String flattenedElementAsString() {
        return flattenedElement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(valueKey());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(flatten());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedElementAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListToMap)) {
            return false;
        }
        ListToMap other = (ListToMap) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(key(), other.key())
                && Objects.equals(valueKey(), other.valueKey()) && Objects.equals(target(), other.target())
                && Objects.equals(flatten(), other.flatten())
                && Objects.equals(flattenedElementAsString(), other.flattenedElementAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListToMap").add("Source", source()).add("Key", key()).add("ValueKey", valueKey())
                .add("Target", target()).add("Flatten", flatten()).add("FlattenedElement", flattenedElementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "valueKey":
            return Optional.ofNullable(clazz.cast(valueKey()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "flatten":
            return Optional.ofNullable(clazz.cast(flatten()));
        case "flattenedElement":
            return Optional.ofNullable(clazz.cast(flattenedElementAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("valueKey", VALUE_KEY_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("flatten", FLATTEN_FIELD);
        map.put("flattenedElement", FLATTENED_ELEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListToMap, T> g) {
        return obj -> g.apply((ListToMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListToMap> {
        /**
         * <p>
         * The key in the log event that has a list of objects that will be converted to a map.
         * </p>
         * 
         * @param source
         *        The key in the log event that has a list of objects that will be converted to a map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The key of the field to be extracted as keys in the generated map
         * </p>
         * 
         * @param key
         *        The key of the field to be extracted as keys in the generated map
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * If this is specified, the values that you specify in this parameter will be extracted from the
         * <code>source</code> objects and put into the values of the generated map. Otherwise, original objects in the
         * source list will be put into the values of the generated map.
         * </p>
         * 
         * @param valueKey
         *        If this is specified, the values that you specify in this parameter will be extracted from the
         *        <code>source</code> objects and put into the values of the generated map. Otherwise, original objects
         *        in the source list will be put into the values of the generated map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueKey(String valueKey);

        /**
         * <p>
         * The key of the field that will hold the generated map
         * </p>
         * 
         * @param target
         *        The key of the field that will hold the generated map
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * A Boolean value to indicate whether the list will be flattened into single items. Specify <code>true</code>
         * to flatten the list. The default is <code>false</code>
         * </p>
         * 
         * @param flatten
         *        A Boolean value to indicate whether the list will be flattened into single items. Specify
         *        <code>true</code> to flatten the list. The default is <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flatten(Boolean flatten);

        /**
         * <p>
         * If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify which
         * element, <code>first</code> or <code>last</code>, to keep.
         * </p>
         * <p>
         * You must specify this parameter if <code>flatten</code> is <code>true</code>
         * </p>
         * 
         * @param flattenedElement
         *        If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify
         *        which element, <code>first</code> or <code>last</code>, to keep. </p>
         *        <p>
         *        You must specify this parameter if <code>flatten</code> is <code>true</code>
         * @see FlattenedElement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlattenedElement
         */
        Builder flattenedElement(String flattenedElement);

        /**
         * <p>
         * If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify which
         * element, <code>first</code> or <code>last</code>, to keep.
         * </p>
         * <p>
         * You must specify this parameter if <code>flatten</code> is <code>true</code>
         * </p>
         * 
         * @param flattenedElement
         *        If you set <code>flatten</code> to <code>true</code>, use <code>flattenedElement</code> to specify
         *        which element, <code>first</code> or <code>last</code>, to keep. </p>
         *        <p>
         *        You must specify this parameter if <code>flatten</code> is <code>true</code>
         * @see FlattenedElement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlattenedElement
         */
        Builder flattenedElement(FlattenedElement flattenedElement);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String key;

        private String valueKey;

        private String target;

        private Boolean flatten;

        private String flattenedElement;

        private BuilderImpl() {
        }

        private BuilderImpl(ListToMap model) {
            source(model.source);
            key(model.key);
            valueKey(model.valueKey);
            target(model.target);
            flatten(model.flatten);
            flattenedElement(model.flattenedElement);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValueKey() {
            return valueKey;
        }

        public final void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        @Override
        public final Builder valueKey(String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Boolean getFlatten() {
            return flatten;
        }

        public final void setFlatten(Boolean flatten) {
            this.flatten = flatten;
        }

        @Override
        public final Builder flatten(Boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public final String getFlattenedElement() {
            return flattenedElement;
        }

        public final void setFlattenedElement(String flattenedElement) {
            this.flattenedElement = flattenedElement;
        }

        @Override
        public final Builder flattenedElement(String flattenedElement) {
            this.flattenedElement = flattenedElement;
            return this;
        }

        @Override
        public final Builder flattenedElement(FlattenedElement flattenedElement) {
            this.flattenedElement(flattenedElement == null ? null : flattenedElement.toString());
            return this;
        }

        @Override
        public ListToMap build() {
            return new ListToMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
