/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the integration configuration. For an integration with OpenSearch Service,
 * this includes information about OpenSearch Service resources such as the collection, the workspace, and policies.
 * </p>
 * <p>
 * This structure is returned by a <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetIntegration.html"
 * >GetIntegration</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationDetails.Builder, IntegrationDetails> {
    private static final SdkField<OpenSearchIntegrationDetails> OPEN_SEARCH_INTEGRATION_DETAILS_FIELD = SdkField
            .<OpenSearchIntegrationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("openSearchIntegrationDetails")
            .getter(getter(IntegrationDetails::openSearchIntegrationDetails))
            .setter(setter(Builder::openSearchIntegrationDetails))
            .constructor(OpenSearchIntegrationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchIntegrationDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OPEN_SEARCH_INTEGRATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpenSearchIntegrationDetails openSearchIntegrationDetails;

    private final Type type;

    private IntegrationDetails(BuilderImpl builder) {
        this.openSearchIntegrationDetails = builder.openSearchIntegrationDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
     * Service.
     * </p>
     * 
     * @return This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
     *         Service.
     */
    public final OpenSearchIntegrationDetails openSearchIntegrationDetails() {
        return openSearchIntegrationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openSearchIntegrationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationDetails)) {
            return false;
        }
        IntegrationDetails other = (IntegrationDetails) obj;
        return Objects.equals(openSearchIntegrationDetails(), other.openSearchIntegrationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationDetails").add("OpenSearchIntegrationDetails", openSearchIntegrationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openSearchIntegrationDetails":
            return Optional.ofNullable(clazz.cast(openSearchIntegrationDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #openSearchIntegrationDetails()} initialized to the given value.
     *
     * <p>
     * This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
     * Service.
     * </p>
     * 
     * @param openSearchIntegrationDetails
     *        This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
     *        Service.
     */
    public static IntegrationDetails fromOpenSearchIntegrationDetails(OpenSearchIntegrationDetails openSearchIntegrationDetails) {
        return builder().openSearchIntegrationDetails(openSearchIntegrationDetails).build();
    }

    /**
     * Create an instance of this class with {@link #openSearchIntegrationDetails()} initialized to the given value.
     *
     * <p>
     * This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
     * Service.
     * </p>
     * 
     * @param openSearchIntegrationDetails
     *        This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
     *        Service.
     */
    public static IntegrationDetails fromOpenSearchIntegrationDetails(
            Consumer<OpenSearchIntegrationDetails.Builder> openSearchIntegrationDetails) {
        OpenSearchIntegrationDetails.Builder builder = OpenSearchIntegrationDetails.builder();
        openSearchIntegrationDetails.accept(builder);
        return fromOpenSearchIntegrationDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("openSearchIntegrationDetails", OPEN_SEARCH_INTEGRATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationDetails, T> g) {
        return obj -> g.apply((IntegrationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationDetails> {
        /**
         * <p>
         * This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
         * Service.
         * </p>
         * 
         * @param openSearchIntegrationDetails
         *        This structure contains complete information about one integration between CloudWatch Logs and
         *        OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchIntegrationDetails(OpenSearchIntegrationDetails openSearchIntegrationDetails);

        /**
         * <p>
         * This structure contains complete information about one integration between CloudWatch Logs and OpenSearch
         * Service.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchIntegrationDetails.Builder}
         * avoiding the need to create one manually via {@link OpenSearchIntegrationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchIntegrationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #openSearchIntegrationDetails(OpenSearchIntegrationDetails)}.
         * 
         * @param openSearchIntegrationDetails
         *        a consumer that will call methods on {@link OpenSearchIntegrationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openSearchIntegrationDetails(OpenSearchIntegrationDetails)
         */
        default Builder openSearchIntegrationDetails(Consumer<OpenSearchIntegrationDetails.Builder> openSearchIntegrationDetails) {
            return openSearchIntegrationDetails(OpenSearchIntegrationDetails.builder()
                    .applyMutation(openSearchIntegrationDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpenSearchIntegrationDetails openSearchIntegrationDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationDetails model) {
            openSearchIntegrationDetails(model.openSearchIntegrationDetails);
        }

        public final OpenSearchIntegrationDetails.Builder getOpenSearchIntegrationDetails() {
            return openSearchIntegrationDetails != null ? openSearchIntegrationDetails.toBuilder() : null;
        }

        public final void setOpenSearchIntegrationDetails(OpenSearchIntegrationDetails.BuilderImpl openSearchIntegrationDetails) {
            Object oldValue = this.openSearchIntegrationDetails;
            this.openSearchIntegrationDetails = openSearchIntegrationDetails != null ? openSearchIntegrationDetails.build()
                    : null;
            handleUnionValueChange(Type.OPEN_SEARCH_INTEGRATION_DETAILS, oldValue, this.openSearchIntegrationDetails);
        }

        @Override
        public final Builder openSearchIntegrationDetails(OpenSearchIntegrationDetails openSearchIntegrationDetails) {
            Object oldValue = this.openSearchIntegrationDetails;
            this.openSearchIntegrationDetails = openSearchIntegrationDetails;
            handleUnionValueChange(Type.OPEN_SEARCH_INTEGRATION_DETAILS, oldValue, this.openSearchIntegrationDetails);
            return this;
        }

        @Override
        public IntegrationDetails build() {
            return new IntegrationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IntegrationDetails#type()
     */
    public enum Type {
        OPEN_SEARCH_INTEGRATION_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
