/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationType;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationTypesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogTypesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationTemplatesRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationTemplatesRequest> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(DescribeConfigurationTemplatesRequest.getter(DescribeConfigurationTemplatesRequest::service)).setter(DescribeConfigurationTemplatesRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<List<String>> LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logTypes").getter(DescribeConfigurationTemplatesRequest.getter(DescribeConfigurationTemplatesRequest::logTypes)).setter(DescribeConfigurationTemplatesRequest.setter(Builder::logTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(DescribeConfigurationTemplatesRequest.getter(DescribeConfigurationTemplatesRequest::resourceTypes)).setter(DescribeConfigurationTemplatesRequest.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DELIVERY_DESTINATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deliveryDestinationTypes").getter(DescribeConfigurationTemplatesRequest.getter(DescribeConfigurationTemplatesRequest::deliveryDestinationTypesAsStrings)).setter(DescribeConfigurationTemplatesRequest.setter(Builder::deliveryDestinationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeConfigurationTemplatesRequest.getter(DescribeConfigurationTemplatesRequest::nextToken)).setter(DescribeConfigurationTemplatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(DescribeConfigurationTemplatesRequest.getter(DescribeConfigurationTemplatesRequest::limit)).setter(DescribeConfigurationTemplatesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, LOG_TYPES_FIELD, RESOURCE_TYPES_FIELD, DELIVERY_DESTINATION_TYPES_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConfigurationTemplatesRequest.memberNameToFieldInitializer();
    private final String service;
    private final List<String> logTypes;
    private final List<String> resourceTypes;
    private final List<String> deliveryDestinationTypes;
    private final String nextToken;
    private final Integer limit;

    private DescribeConfigurationTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.logTypes = builder.logTypes;
        this.resourceTypes = builder.resourceTypes;
        this.deliveryDestinationTypes = builder.deliveryDestinationTypes;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public final String service() {
        return this.service;
    }

    public final boolean hasLogTypes() {
        return this.logTypes != null && !(this.logTypes instanceof SdkAutoConstructList);
    }

    public final List<String> logTypes() {
        return this.logTypes;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final List<DeliveryDestinationType> deliveryDestinationTypes() {
        return DeliveryDestinationTypesCopier.copyStringToEnum(this.deliveryDestinationTypes);
    }

    public final boolean hasDeliveryDestinationTypes() {
        return this.deliveryDestinationTypes != null && !(this.deliveryDestinationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> deliveryDestinationTypesAsStrings() {
        return this.deliveryDestinationTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypes() ? this.logTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveryDestinationTypes() ? this.deliveryDestinationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationTemplatesRequest)) {
            return false;
        }
        DescribeConfigurationTemplatesRequest other = (DescribeConfigurationTemplatesRequest)((Object)obj);
        return Objects.equals(this.service(), other.service()) && this.hasLogTypes() == other.hasLogTypes() && Objects.equals(this.logTypes(), other.logTypes()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && this.hasDeliveryDestinationTypes() == other.hasDeliveryDestinationTypes() && Objects.equals(this.deliveryDestinationTypesAsStrings(), other.deliveryDestinationTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationTemplatesRequest").add("Service", (Object)this.service()).add("LogTypes", this.hasLogTypes() ? this.logTypes() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("DeliveryDestinationTypes", this.hasDeliveryDestinationTypes() ? this.deliveryDestinationTypesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "logTypes": {
                return Optional.ofNullable(clazz.cast(this.logTypes()));
            }
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "deliveryDestinationTypes": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationTypesAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("service", SERVICE_FIELD);
        map.put("logTypes", LOG_TYPES_FIELD);
        map.put("resourceTypes", RESOURCE_TYPES_FIELD);
        map.put("deliveryDestinationTypes", DELIVERY_DESTINATION_TYPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationTemplatesRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationTemplatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String service;
        private List<String> logTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> deliveryDestinationTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationTemplatesRequest model) {
            super(model);
            this.service(model.service);
            this.logTypes(model.logTypes);
            this.resourceTypes(model.resourceTypes);
            this.deliveryDestinationTypesWithStrings(model.deliveryDestinationTypes);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Collection<String> getLogTypes() {
            if (this.logTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logTypes;
        }

        public final void setLogTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypes(String ... logTypes) {
            this.logTypes(Arrays.asList(logTypes));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getDeliveryDestinationTypes() {
            if (this.deliveryDestinationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deliveryDestinationTypes;
        }

        public final void setDeliveryDestinationTypes(Collection<String> deliveryDestinationTypes) {
            this.deliveryDestinationTypes = DeliveryDestinationTypesCopier.copy(deliveryDestinationTypes);
        }

        @Override
        public final Builder deliveryDestinationTypesWithStrings(Collection<String> deliveryDestinationTypes) {
            this.deliveryDestinationTypes = DeliveryDestinationTypesCopier.copy(deliveryDestinationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryDestinationTypesWithStrings(String ... deliveryDestinationTypes) {
            this.deliveryDestinationTypesWithStrings(Arrays.asList(deliveryDestinationTypes));
            return this;
        }

        @Override
        public final Builder deliveryDestinationTypes(Collection<DeliveryDestinationType> deliveryDestinationTypes) {
            this.deliveryDestinationTypes = DeliveryDestinationTypesCopier.copyEnumToString(deliveryDestinationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryDestinationTypes(DeliveryDestinationType ... deliveryDestinationTypes) {
            this.deliveryDestinationTypes(Arrays.asList(deliveryDestinationTypes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationTemplatesRequest build() {
            return new DescribeConfigurationTemplatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationTemplatesRequest> {
        public Builder service(String var1);

        public Builder logTypes(Collection<String> var1);

        public Builder logTypes(String ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder deliveryDestinationTypesWithStrings(Collection<String> var1);

        public Builder deliveryDestinationTypesWithStrings(String ... var1);

        public Builder deliveryDestinationTypes(Collection<DeliveryDestinationType> var1);

        public Builder deliveryDestinationTypes(DeliveryDestinationType ... var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

