/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationType;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationName").getter(PutIntegrationRequest.getter(PutIntegrationRequest::integrationName)).setter(PutIntegrationRequest.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationName").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfig").getter(PutIntegrationRequest.getter(PutIntegrationRequest::resourceConfig)).setter(PutIntegrationRequest.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationType").getter(PutIntegrationRequest.getter(PutIntegrationRequest::integrationTypeAsString)).setter(PutIntegrationRequest.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD, RESOURCE_CONFIG_FIELD, INTEGRATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("integrationName", INTEGRATION_NAME_FIELD);
            this.put("resourceConfig", RESOURCE_CONFIG_FIELD);
            this.put("integrationType", INTEGRATION_TYPE_FIELD);
        }
    });
    private final String integrationName;
    private final ResourceConfig resourceConfig;
    private final String integrationType;

    private PutIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.resourceConfig = builder.resourceConfig;
        this.integrationType = builder.integrationType;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public final String integrationTypeAsString() {
        return this.integrationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationRequest)) {
            return false;
        }
        PutIntegrationRequest other = (PutIntegrationRequest)((Object)obj);
        return Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntegrationRequest").add("IntegrationName", (Object)this.integrationName()).add("ResourceConfig", (Object)this.resourceConfig()).add("IntegrationType", (Object)this.integrationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "resourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "integrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationRequest, T> g) {
        return obj -> g.apply((PutIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String integrationName;
        private ResourceConfig resourceConfig;
        private String integrationType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationRequest model) {
            super(model);
            this.integrationName(model.integrationName);
            this.resourceConfig(model.resourceConfig);
            this.integrationType(model.integrationType);
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationRequest build() {
            return new PutIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationRequest> {
        public Builder integrationName(String var1);

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

