/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.EnumerationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatternToken
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatternToken> {
    private static final SdkField<Integer> DYNAMIC_TOKEN_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dynamicTokenPosition").getter(PatternToken.getter(PatternToken::dynamicTokenPosition)).setter(PatternToken.setter(Builder::dynamicTokenPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicTokenPosition").build()}).build();
    private static final SdkField<Boolean> IS_DYNAMIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDynamic").getter(PatternToken.getter(PatternToken::isDynamic)).setter(PatternToken.setter(Builder::isDynamic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDynamic").build()}).build();
    private static final SdkField<String> TOKEN_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenString").getter(PatternToken.getter(PatternToken::tokenString)).setter(PatternToken.setter(Builder::tokenString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenString").build()}).build();
    private static final SdkField<Map<String, Long>> ENUMERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("enumerations").getter(PatternToken.getter(PatternToken::enumerations)).setter(PatternToken.setter(Builder::enumerations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> INFERRED_TOKEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferredTokenName").getter(PatternToken.getter(PatternToken::inferredTokenName)).setter(PatternToken.setter(Builder::inferredTokenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredTokenName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_TOKEN_POSITION_FIELD, IS_DYNAMIC_FIELD, TOKEN_STRING_FIELD, ENUMERATIONS_FIELD, INFERRED_TOKEN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dynamicTokenPosition", DYNAMIC_TOKEN_POSITION_FIELD);
            this.put("isDynamic", IS_DYNAMIC_FIELD);
            this.put("tokenString", TOKEN_STRING_FIELD);
            this.put("enumerations", ENUMERATIONS_FIELD);
            this.put("inferredTokenName", INFERRED_TOKEN_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer dynamicTokenPosition;
    private final Boolean isDynamic;
    private final String tokenString;
    private final Map<String, Long> enumerations;
    private final String inferredTokenName;

    private PatternToken(BuilderImpl builder) {
        this.dynamicTokenPosition = builder.dynamicTokenPosition;
        this.isDynamic = builder.isDynamic;
        this.tokenString = builder.tokenString;
        this.enumerations = builder.enumerations;
        this.inferredTokenName = builder.inferredTokenName;
    }

    public final Integer dynamicTokenPosition() {
        return this.dynamicTokenPosition;
    }

    public final Boolean isDynamic() {
        return this.isDynamic;
    }

    public final String tokenString() {
        return this.tokenString;
    }

    public final boolean hasEnumerations() {
        return this.enumerations != null && !(this.enumerations instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> enumerations() {
        return this.enumerations;
    }

    public final String inferredTokenName() {
        return this.inferredTokenName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicTokenPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDynamic());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnumerations() ? this.enumerations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferredTokenName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternToken)) {
            return false;
        }
        PatternToken other = (PatternToken)obj;
        return Objects.equals(this.dynamicTokenPosition(), other.dynamicTokenPosition()) && Objects.equals(this.isDynamic(), other.isDynamic()) && Objects.equals(this.tokenString(), other.tokenString()) && this.hasEnumerations() == other.hasEnumerations() && Objects.equals(this.enumerations(), other.enumerations()) && Objects.equals(this.inferredTokenName(), other.inferredTokenName());
    }

    public final String toString() {
        return ToString.builder((String)"PatternToken").add("DynamicTokenPosition", (Object)this.dynamicTokenPosition()).add("IsDynamic", (Object)this.isDynamic()).add("TokenString", (Object)this.tokenString()).add("Enumerations", this.hasEnumerations() ? this.enumerations() : null).add("InferredTokenName", (Object)this.inferredTokenName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dynamicTokenPosition": {
                return Optional.ofNullable(clazz.cast(this.dynamicTokenPosition()));
            }
            case "isDynamic": {
                return Optional.ofNullable(clazz.cast(this.isDynamic()));
            }
            case "tokenString": {
                return Optional.ofNullable(clazz.cast(this.tokenString()));
            }
            case "enumerations": {
                return Optional.ofNullable(clazz.cast(this.enumerations()));
            }
            case "inferredTokenName": {
                return Optional.ofNullable(clazz.cast(this.inferredTokenName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PatternToken, T> g) {
        return obj -> g.apply((PatternToken)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dynamicTokenPosition;
        private Boolean isDynamic;
        private String tokenString;
        private Map<String, Long> enumerations = DefaultSdkAutoConstructMap.getInstance();
        private String inferredTokenName;

        private BuilderImpl() {
        }

        private BuilderImpl(PatternToken model) {
            this.dynamicTokenPosition(model.dynamicTokenPosition);
            this.isDynamic(model.isDynamic);
            this.tokenString(model.tokenString);
            this.enumerations(model.enumerations);
            this.inferredTokenName(model.inferredTokenName);
        }

        public final Integer getDynamicTokenPosition() {
            return this.dynamicTokenPosition;
        }

        public final void setDynamicTokenPosition(Integer dynamicTokenPosition) {
            this.dynamicTokenPosition = dynamicTokenPosition;
        }

        @Override
        public final Builder dynamicTokenPosition(Integer dynamicTokenPosition) {
            this.dynamicTokenPosition = dynamicTokenPosition;
            return this;
        }

        public final Boolean getIsDynamic() {
            return this.isDynamic;
        }

        public final void setIsDynamic(Boolean isDynamic) {
            this.isDynamic = isDynamic;
        }

        @Override
        public final Builder isDynamic(Boolean isDynamic) {
            this.isDynamic = isDynamic;
            return this;
        }

        public final String getTokenString() {
            return this.tokenString;
        }

        public final void setTokenString(String tokenString) {
            this.tokenString = tokenString;
        }

        @Override
        public final Builder tokenString(String tokenString) {
            this.tokenString = tokenString;
            return this;
        }

        public final Map<String, Long> getEnumerations() {
            if (this.enumerations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.enumerations;
        }

        public final void setEnumerations(Map<String, Long> enumerations) {
            this.enumerations = EnumerationsCopier.copy(enumerations);
        }

        @Override
        public final Builder enumerations(Map<String, Long> enumerations) {
            this.enumerations = EnumerationsCopier.copy(enumerations);
            return this;
        }

        public final String getInferredTokenName() {
            return this.inferredTokenName;
        }

        public final void setInferredTokenName(String inferredTokenName) {
            this.inferredTokenName = inferredTokenName;
        }

        @Override
        public final Builder inferredTokenName(String inferredTokenName) {
            this.inferredTokenName = inferredTokenName;
            return this;
        }

        public PatternToken build() {
            return new PatternToken(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatternToken> {
        public Builder dynamicTokenPosition(Integer var1);

        public Builder isDynamic(Boolean var1);

        public Builder tokenString(String var1);

        public Builder enumerations(Map<String, Long> var1);

        public Builder inferredTokenName(String var1);
    }
}

