/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchApplication;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchCollection;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchDataSource;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchEncryptionPolicy;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchNetworkPolicy;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchWorkspace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchIntegrationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchIntegrationDetails> {
    private static final SdkField<OpenSearchDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::dataSource)).setter(OpenSearchIntegrationDetails.setter(Builder::dataSource)).constructor(OpenSearchDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<OpenSearchApplication> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("application").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::application)).setter(OpenSearchIntegrationDetails.setter(Builder::application)).constructor(OpenSearchApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<OpenSearchCollection> COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collection").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::collection)).setter(OpenSearchIntegrationDetails.setter(Builder::collection)).constructor(OpenSearchCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collection").build()}).build();
    private static final SdkField<OpenSearchWorkspace> WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workspace").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::workspace)).setter(OpenSearchIntegrationDetails.setter(Builder::workspace)).constructor(OpenSearchWorkspace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()}).build();
    private static final SdkField<OpenSearchEncryptionPolicy> ENCRYPTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionPolicy").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::encryptionPolicy)).setter(OpenSearchIntegrationDetails.setter(Builder::encryptionPolicy)).constructor(OpenSearchEncryptionPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionPolicy").build()}).build();
    private static final SdkField<OpenSearchNetworkPolicy> NETWORK_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkPolicy").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::networkPolicy)).setter(OpenSearchIntegrationDetails.setter(Builder::networkPolicy)).constructor(OpenSearchNetworkPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkPolicy").build()}).build();
    private static final SdkField<OpenSearchDataAccessPolicy> ACCESS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessPolicy").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::accessPolicy)).setter(OpenSearchIntegrationDetails.setter(Builder::accessPolicy)).constructor(OpenSearchDataAccessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()}).build();
    private static final SdkField<OpenSearchLifecyclePolicy> LIFECYCLE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecyclePolicy").getter(OpenSearchIntegrationDetails.getter(OpenSearchIntegrationDetails::lifecyclePolicy)).setter(OpenSearchIntegrationDetails.setter(Builder::lifecyclePolicy)).constructor(OpenSearchLifecyclePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, APPLICATION_FIELD, COLLECTION_FIELD, WORKSPACE_FIELD, ENCRYPTION_POLICY_FIELD, NETWORK_POLICY_FIELD, ACCESS_POLICY_FIELD, LIFECYCLE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dataSource", DATA_SOURCE_FIELD);
            this.put("application", APPLICATION_FIELD);
            this.put("collection", COLLECTION_FIELD);
            this.put("workspace", WORKSPACE_FIELD);
            this.put("encryptionPolicy", ENCRYPTION_POLICY_FIELD);
            this.put("networkPolicy", NETWORK_POLICY_FIELD);
            this.put("accessPolicy", ACCESS_POLICY_FIELD);
            this.put("lifecyclePolicy", LIFECYCLE_POLICY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final OpenSearchDataSource dataSource;
    private final OpenSearchApplication application;
    private final OpenSearchCollection collection;
    private final OpenSearchWorkspace workspace;
    private final OpenSearchEncryptionPolicy encryptionPolicy;
    private final OpenSearchNetworkPolicy networkPolicy;
    private final OpenSearchDataAccessPolicy accessPolicy;
    private final OpenSearchLifecyclePolicy lifecyclePolicy;

    private OpenSearchIntegrationDetails(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.application = builder.application;
        this.collection = builder.collection;
        this.workspace = builder.workspace;
        this.encryptionPolicy = builder.encryptionPolicy;
        this.networkPolicy = builder.networkPolicy;
        this.accessPolicy = builder.accessPolicy;
        this.lifecyclePolicy = builder.lifecyclePolicy;
    }

    public final OpenSearchDataSource dataSource() {
        return this.dataSource;
    }

    public final OpenSearchApplication application() {
        return this.application;
    }

    public final OpenSearchCollection collection() {
        return this.collection;
    }

    public final OpenSearchWorkspace workspace() {
        return this.workspace;
    }

    public final OpenSearchEncryptionPolicy encryptionPolicy() {
        return this.encryptionPolicy;
    }

    public final OpenSearchNetworkPolicy networkPolicy() {
        return this.networkPolicy;
    }

    public final OpenSearchDataAccessPolicy accessPolicy() {
        return this.accessPolicy;
    }

    public final OpenSearchLifecyclePolicy lifecyclePolicy() {
        return this.lifecyclePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.collection());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspace());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchIntegrationDetails)) {
            return false;
        }
        OpenSearchIntegrationDetails other = (OpenSearchIntegrationDetails)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.application(), other.application()) && Objects.equals(this.collection(), other.collection()) && Objects.equals(this.workspace(), other.workspace()) && Objects.equals(this.encryptionPolicy(), other.encryptionPolicy()) && Objects.equals(this.networkPolicy(), other.networkPolicy()) && Objects.equals(this.accessPolicy(), other.accessPolicy()) && Objects.equals(this.lifecyclePolicy(), other.lifecyclePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchIntegrationDetails").add("DataSource", (Object)this.dataSource()).add("Application", (Object)this.application()).add("Collection", (Object)this.collection()).add("Workspace", (Object)this.workspace()).add("EncryptionPolicy", (Object)this.encryptionPolicy()).add("NetworkPolicy", (Object)this.networkPolicy()).add("AccessPolicy", (Object)this.accessPolicy()).add("LifecyclePolicy", (Object)this.lifecyclePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "collection": {
                return Optional.ofNullable(clazz.cast(this.collection()));
            }
            case "workspace": {
                return Optional.ofNullable(clazz.cast(this.workspace()));
            }
            case "encryptionPolicy": {
                return Optional.ofNullable(clazz.cast(this.encryptionPolicy()));
            }
            case "networkPolicy": {
                return Optional.ofNullable(clazz.cast(this.networkPolicy()));
            }
            case "accessPolicy": {
                return Optional.ofNullable(clazz.cast(this.accessPolicy()));
            }
            case "lifecyclePolicy": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchIntegrationDetails, T> g) {
        return obj -> g.apply((OpenSearchIntegrationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OpenSearchDataSource dataSource;
        private OpenSearchApplication application;
        private OpenSearchCollection collection;
        private OpenSearchWorkspace workspace;
        private OpenSearchEncryptionPolicy encryptionPolicy;
        private OpenSearchNetworkPolicy networkPolicy;
        private OpenSearchDataAccessPolicy accessPolicy;
        private OpenSearchLifecyclePolicy lifecyclePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchIntegrationDetails model) {
            this.dataSource(model.dataSource);
            this.application(model.application);
            this.collection(model.collection);
            this.workspace(model.workspace);
            this.encryptionPolicy(model.encryptionPolicy);
            this.networkPolicy(model.networkPolicy);
            this.accessPolicy(model.accessPolicy);
            this.lifecyclePolicy(model.lifecyclePolicy);
        }

        public final OpenSearchDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(OpenSearchDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(OpenSearchDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final OpenSearchApplication.Builder getApplication() {
            return this.application != null ? this.application.toBuilder() : null;
        }

        public final void setApplication(OpenSearchApplication.BuilderImpl application) {
            this.application = application != null ? application.build() : null;
        }

        @Override
        public final Builder application(OpenSearchApplication application) {
            this.application = application;
            return this;
        }

        public final OpenSearchCollection.Builder getCollection() {
            return this.collection != null ? this.collection.toBuilder() : null;
        }

        public final void setCollection(OpenSearchCollection.BuilderImpl collection) {
            this.collection = collection != null ? collection.build() : null;
        }

        @Override
        public final Builder collection(OpenSearchCollection collection) {
            this.collection = collection;
            return this;
        }

        public final OpenSearchWorkspace.Builder getWorkspace() {
            return this.workspace != null ? this.workspace.toBuilder() : null;
        }

        public final void setWorkspace(OpenSearchWorkspace.BuilderImpl workspace) {
            this.workspace = workspace != null ? workspace.build() : null;
        }

        @Override
        public final Builder workspace(OpenSearchWorkspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public final OpenSearchEncryptionPolicy.Builder getEncryptionPolicy() {
            return this.encryptionPolicy != null ? this.encryptionPolicy.toBuilder() : null;
        }

        public final void setEncryptionPolicy(OpenSearchEncryptionPolicy.BuilderImpl encryptionPolicy) {
            this.encryptionPolicy = encryptionPolicy != null ? encryptionPolicy.build() : null;
        }

        @Override
        public final Builder encryptionPolicy(OpenSearchEncryptionPolicy encryptionPolicy) {
            this.encryptionPolicy = encryptionPolicy;
            return this;
        }

        public final OpenSearchNetworkPolicy.Builder getNetworkPolicy() {
            return this.networkPolicy != null ? this.networkPolicy.toBuilder() : null;
        }

        public final void setNetworkPolicy(OpenSearchNetworkPolicy.BuilderImpl networkPolicy) {
            this.networkPolicy = networkPolicy != null ? networkPolicy.build() : null;
        }

        @Override
        public final Builder networkPolicy(OpenSearchNetworkPolicy networkPolicy) {
            this.networkPolicy = networkPolicy;
            return this;
        }

        public final OpenSearchDataAccessPolicy.Builder getAccessPolicy() {
            return this.accessPolicy != null ? this.accessPolicy.toBuilder() : null;
        }

        public final void setAccessPolicy(OpenSearchDataAccessPolicy.BuilderImpl accessPolicy) {
            this.accessPolicy = accessPolicy != null ? accessPolicy.build() : null;
        }

        @Override
        public final Builder accessPolicy(OpenSearchDataAccessPolicy accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final OpenSearchLifecyclePolicy.Builder getLifecyclePolicy() {
            return this.lifecyclePolicy != null ? this.lifecyclePolicy.toBuilder() : null;
        }

        public final void setLifecyclePolicy(OpenSearchLifecyclePolicy.BuilderImpl lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy != null ? lifecyclePolicy.build() : null;
        }

        @Override
        public final Builder lifecyclePolicy(OpenSearchLifecyclePolicy lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        public OpenSearchIntegrationDetails build() {
            return new OpenSearchIntegrationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchIntegrationDetails> {
        public Builder dataSource(OpenSearchDataSource var1);

        default public Builder dataSource(Consumer<OpenSearchDataSource.Builder> dataSource) {
            return this.dataSource((OpenSearchDataSource)((OpenSearchDataSource.Builder)OpenSearchDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder application(OpenSearchApplication var1);

        default public Builder application(Consumer<OpenSearchApplication.Builder> application) {
            return this.application((OpenSearchApplication)((OpenSearchApplication.Builder)OpenSearchApplication.builder().applyMutation(application)).build());
        }

        public Builder collection(OpenSearchCollection var1);

        default public Builder collection(Consumer<OpenSearchCollection.Builder> collection) {
            return this.collection((OpenSearchCollection)((OpenSearchCollection.Builder)OpenSearchCollection.builder().applyMutation(collection)).build());
        }

        public Builder workspace(OpenSearchWorkspace var1);

        default public Builder workspace(Consumer<OpenSearchWorkspace.Builder> workspace) {
            return this.workspace((OpenSearchWorkspace)((OpenSearchWorkspace.Builder)OpenSearchWorkspace.builder().applyMutation(workspace)).build());
        }

        public Builder encryptionPolicy(OpenSearchEncryptionPolicy var1);

        default public Builder encryptionPolicy(Consumer<OpenSearchEncryptionPolicy.Builder> encryptionPolicy) {
            return this.encryptionPolicy((OpenSearchEncryptionPolicy)((OpenSearchEncryptionPolicy.Builder)OpenSearchEncryptionPolicy.builder().applyMutation(encryptionPolicy)).build());
        }

        public Builder networkPolicy(OpenSearchNetworkPolicy var1);

        default public Builder networkPolicy(Consumer<OpenSearchNetworkPolicy.Builder> networkPolicy) {
            return this.networkPolicy((OpenSearchNetworkPolicy)((OpenSearchNetworkPolicy.Builder)OpenSearchNetworkPolicy.builder().applyMutation(networkPolicy)).build());
        }

        public Builder accessPolicy(OpenSearchDataAccessPolicy var1);

        default public Builder accessPolicy(Consumer<OpenSearchDataAccessPolicy.Builder> accessPolicy) {
            return this.accessPolicy((OpenSearchDataAccessPolicy)((OpenSearchDataAccessPolicy.Builder)OpenSearchDataAccessPolicy.builder().applyMutation(accessPolicy)).build());
        }

        public Builder lifecyclePolicy(OpenSearchLifecyclePolicy var1);

        default public Builder lifecyclePolicy(Consumer<OpenSearchLifecyclePolicy.Builder> lifecyclePolicy) {
            return this.lifecyclePolicy((OpenSearchLifecyclePolicy)((OpenSearchLifecyclePolicy.Builder)OpenSearchLifecyclePolicy.builder().applyMutation(lifecyclePolicy)).build());
        }
    }
}

