/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TransformedLogRecord;
import software.amazon.awssdk.services.cloudwatchlogs.model.TransformedLogsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestTransformerResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, TestTransformerResponse> {
    private static final SdkField<List<TransformedLogRecord>> TRANSFORMED_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transformedLogs").getter(TestTransformerResponse.getter(TestTransformerResponse::transformedLogs)).setter(TestTransformerResponse.setter(Builder::transformedLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformedLogs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransformedLogRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMED_LOGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("transformedLogs", TRANSFORMED_LOGS_FIELD);
        }
    });
    private final List<TransformedLogRecord> transformedLogs;

    private TestTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.transformedLogs = builder.transformedLogs;
    }

    public final boolean hasTransformedLogs() {
        return this.transformedLogs != null && !(this.transformedLogs instanceof SdkAutoConstructList);
    }

    public final List<TransformedLogRecord> transformedLogs() {
        return this.transformedLogs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformedLogs() ? this.transformedLogs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTransformerResponse)) {
            return false;
        }
        TestTransformerResponse other = (TestTransformerResponse)((Object)obj);
        return this.hasTransformedLogs() == other.hasTransformedLogs() && Objects.equals(this.transformedLogs(), other.transformedLogs());
    }

    public final String toString() {
        return ToString.builder((String)"TestTransformerResponse").add("TransformedLogs", this.hasTransformedLogs() ? this.transformedLogs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformedLogs": {
                return Optional.ofNullable(clazz.cast(this.transformedLogs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestTransformerResponse, T> g) {
        return obj -> g.apply((TestTransformerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<TransformedLogRecord> transformedLogs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestTransformerResponse model) {
            super(model);
            this.transformedLogs(model.transformedLogs);
        }

        public final List<TransformedLogRecord.Builder> getTransformedLogs() {
            List<TransformedLogRecord.Builder> result = TransformedLogsCopier.copyToBuilder(this.transformedLogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformedLogs(Collection<TransformedLogRecord.BuilderImpl> transformedLogs) {
            this.transformedLogs = TransformedLogsCopier.copyFromBuilder(transformedLogs);
        }

        @Override
        public final Builder transformedLogs(Collection<TransformedLogRecord> transformedLogs) {
            this.transformedLogs = TransformedLogsCopier.copy(transformedLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformedLogs(TransformedLogRecord ... transformedLogs) {
            this.transformedLogs(Arrays.asList(transformedLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformedLogs(Consumer<TransformedLogRecord.Builder> ... transformedLogs) {
            this.transformedLogs(Stream.of(transformedLogs).map(c -> (TransformedLogRecord)((TransformedLogRecord.Builder)TransformedLogRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TestTransformerResponse build() {
            return new TestTransformerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestTransformerResponse> {
        public Builder transformedLogs(Collection<TransformedLogRecord> var1);

        public Builder transformedLogs(TransformedLogRecord ... var1);

        public Builder transformedLogs(Consumer<TransformedLogRecord.Builder> ... var1);
    }
}

