/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchNetworkPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchNetworkPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(OpenSearchNetworkPolicy.getter(OpenSearchNetworkPolicy::policyName)).setter(OpenSearchNetworkPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<OpenSearchResourceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(OpenSearchNetworkPolicy.getter(OpenSearchNetworkPolicy::status)).setter(OpenSearchNetworkPolicy.setter(Builder::status)).constructor(OpenSearchResourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyName", POLICY_NAME_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final OpenSearchResourceStatus status;

    private OpenSearchNetworkPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.status = builder.status;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final OpenSearchResourceStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchNetworkPolicy)) {
            return false;
        }
        OpenSearchNetworkPolicy other = (OpenSearchNetworkPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchNetworkPolicy").add("PolicyName", (Object)this.policyName()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchNetworkPolicy, T> g) {
        return obj -> g.apply((OpenSearchNetworkPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private OpenSearchResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchNetworkPolicy model) {
            this.policyName(model.policyName);
            this.status(model.status);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final OpenSearchResourceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(OpenSearchResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OpenSearchResourceStatus status) {
            this.status = status;
            return this;
        }

        public OpenSearchNetworkPolicy build() {
            return new OpenSearchNetworkPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchNetworkPolicy> {
        public Builder policyName(String var1);

        public Builder status(OpenSearchResourceStatus var1);

        default public Builder status(Consumer<OpenSearchResourceStatus.Builder> status) {
            return this.status((OpenSearchResourceStatus)((OpenSearchResourceStatus.Builder)OpenSearchResourceStatus.builder().applyMutation(status)).build());
        }
    }
}

