/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.Processor;
import software.amazon.awssdk.services.cloudwatchlogs.model.ProcessorsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestEventMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestTransformerRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, TestTransformerRequest> {
    private static final SdkField<List<Processor>> TRANSFORMER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transformerConfig").getter(TestTransformerRequest.getter(TestTransformerRequest::transformerConfig)).setter(TestTransformerRequest.setter(Builder::transformerConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_EVENT_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logEventMessages").getter(TestTransformerRequest.getter(TestTransformerRequest::logEventMessages)).setter(TestTransformerRequest.setter(Builder::logEventMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEventMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_CONFIG_FIELD, LOG_EVENT_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("transformerConfig", TRANSFORMER_CONFIG_FIELD);
            this.put("logEventMessages", LOG_EVENT_MESSAGES_FIELD);
        }
    });
    private final List<Processor> transformerConfig;
    private final List<String> logEventMessages;

    private TestTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.transformerConfig = builder.transformerConfig;
        this.logEventMessages = builder.logEventMessages;
    }

    public final boolean hasTransformerConfig() {
        return this.transformerConfig != null && !(this.transformerConfig instanceof SdkAutoConstructList);
    }

    public final List<Processor> transformerConfig() {
        return this.transformerConfig;
    }

    public final boolean hasLogEventMessages() {
        return this.logEventMessages != null && !(this.logEventMessages instanceof SdkAutoConstructList);
    }

    public final List<String> logEventMessages() {
        return this.logEventMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformerConfig() ? this.transformerConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogEventMessages() ? this.logEventMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTransformerRequest)) {
            return false;
        }
        TestTransformerRequest other = (TestTransformerRequest)((Object)obj);
        return this.hasTransformerConfig() == other.hasTransformerConfig() && Objects.equals(this.transformerConfig(), other.transformerConfig()) && this.hasLogEventMessages() == other.hasLogEventMessages() && Objects.equals(this.logEventMessages(), other.logEventMessages());
    }

    public final String toString() {
        return ToString.builder((String)"TestTransformerRequest").add("TransformerConfig", this.hasTransformerConfig() ? this.transformerConfig() : null).add("LogEventMessages", this.hasLogEventMessages() ? this.logEventMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformerConfig": {
                return Optional.ofNullable(clazz.cast(this.transformerConfig()));
            }
            case "logEventMessages": {
                return Optional.ofNullable(clazz.cast(this.logEventMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestTransformerRequest, T> g) {
        return obj -> g.apply((TestTransformerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private List<Processor> transformerConfig = DefaultSdkAutoConstructList.getInstance();
        private List<String> logEventMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestTransformerRequest model) {
            super(model);
            this.transformerConfig(model.transformerConfig);
            this.logEventMessages(model.logEventMessages);
        }

        public final List<Processor.Builder> getTransformerConfig() {
            List<Processor.Builder> result = ProcessorsCopier.copyToBuilder(this.transformerConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformerConfig(Collection<Processor.BuilderImpl> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copyFromBuilder(transformerConfig);
        }

        @Override
        public final Builder transformerConfig(Collection<Processor> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copy(transformerConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Processor ... transformerConfig) {
            this.transformerConfig(Arrays.asList(transformerConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Consumer<Processor.Builder> ... transformerConfig) {
            this.transformerConfig(Stream.of(transformerConfig).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLogEventMessages() {
            if (this.logEventMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logEventMessages;
        }

        public final void setLogEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
        }

        @Override
        public final Builder logEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEventMessages(String ... logEventMessages) {
            this.logEventMessages(Arrays.asList(logEventMessages));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestTransformerRequest build() {
            return new TestTransformerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestTransformerRequest> {
        public Builder transformerConfig(Collection<Processor> var1);

        public Builder transformerConfig(Processor ... var1);

        public Builder transformerConfig(Consumer<Processor.Builder> ... var1);

        public Builder logEventMessages(Collection<String> var1);

        public Builder logEventMessages(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

