/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestEventMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestMetricFilterRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, TestMetricFilterRequest> {
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(TestMetricFilterRequest.getter(TestMetricFilterRequest::filterPattern)).setter(TestMetricFilterRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<List<String>> LOG_EVENT_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logEventMessages").getter(TestMetricFilterRequest.getter(TestMetricFilterRequest::logEventMessages)).setter(TestMetricFilterRequest.setter(Builder::logEventMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEventMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_PATTERN_FIELD, LOG_EVENT_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("filterPattern", FILTER_PATTERN_FIELD);
            this.put("logEventMessages", LOG_EVENT_MESSAGES_FIELD);
        }
    });
    private final String filterPattern;
    private final List<String> logEventMessages;

    private TestMetricFilterRequest(BuilderImpl builder) {
        super(builder);
        this.filterPattern = builder.filterPattern;
        this.logEventMessages = builder.logEventMessages;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final boolean hasLogEventMessages() {
        return this.logEventMessages != null && !(this.logEventMessages instanceof SdkAutoConstructList);
    }

    public final List<String> logEventMessages() {
        return this.logEventMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogEventMessages() ? this.logEventMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterRequest)) {
            return false;
        }
        TestMetricFilterRequest other = (TestMetricFilterRequest)((Object)obj);
        return Objects.equals(this.filterPattern(), other.filterPattern()) && this.hasLogEventMessages() == other.hasLogEventMessages() && Objects.equals(this.logEventMessages(), other.logEventMessages());
    }

    public final String toString() {
        return ToString.builder((String)"TestMetricFilterRequest").add("FilterPattern", (Object)this.filterPattern()).add("LogEventMessages", this.hasLogEventMessages() ? this.logEventMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "logEventMessages": {
                return Optional.ofNullable(clazz.cast(this.logEventMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestMetricFilterRequest, T> g) {
        return obj -> g.apply((TestMetricFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String filterPattern;
        private List<String> logEventMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterRequest model) {
            super(model);
            this.filterPattern(model.filterPattern);
            this.logEventMessages(model.logEventMessages);
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final Collection<String> getLogEventMessages() {
            if (this.logEventMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logEventMessages;
        }

        public final void setLogEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
        }

        @Override
        public final Builder logEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEventMessages(String ... logEventMessages) {
            this.logEventMessages(Arrays.asList(logEventMessages));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestMetricFilterRequest build() {
            return new TestMetricFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestMetricFilterRequest> {
        public Builder filterPattern(String var1);

        public Builder logEventMessages(Collection<String> var1);

        public Builder logEventMessages(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

