/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DeliveryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DeliveryConfiguration> {
    private static final SdkField<String> SUFFIX_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suffixPath").getter(S3DeliveryConfiguration.getter(S3DeliveryConfiguration::suffixPath)).setter(S3DeliveryConfiguration.setter(Builder::suffixPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suffixPath").build()}).build();
    private static final SdkField<Boolean> ENABLE_HIVE_COMPATIBLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableHiveCompatiblePath").getter(S3DeliveryConfiguration.getter(S3DeliveryConfiguration::enableHiveCompatiblePath)).setter(S3DeliveryConfiguration.setter(Builder::enableHiveCompatiblePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableHiveCompatiblePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUFFIX_PATH_FIELD, ENABLE_HIVE_COMPATIBLE_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String suffixPath;
    private final Boolean enableHiveCompatiblePath;

    private S3DeliveryConfiguration(BuilderImpl builder) {
        this.suffixPath = builder.suffixPath;
        this.enableHiveCompatiblePath = builder.enableHiveCompatiblePath;
    }

    public final String suffixPath() {
        return this.suffixPath;
    }

    public final Boolean enableHiveCompatiblePath() {
        return this.enableHiveCompatiblePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suffixPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableHiveCompatiblePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DeliveryConfiguration)) {
            return false;
        }
        S3DeliveryConfiguration other = (S3DeliveryConfiguration)obj;
        return Objects.equals(this.suffixPath(), other.suffixPath()) && Objects.equals(this.enableHiveCompatiblePath(), other.enableHiveCompatiblePath());
    }

    public final String toString() {
        return ToString.builder((String)"S3DeliveryConfiguration").add("SuffixPath", (Object)this.suffixPath()).add("EnableHiveCompatiblePath", (Object)this.enableHiveCompatiblePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suffixPath": {
                return Optional.ofNullable(clazz.cast(this.suffixPath()));
            }
            case "enableHiveCompatiblePath": {
                return Optional.ofNullable(clazz.cast(this.enableHiveCompatiblePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DeliveryConfiguration, T> g) {
        return obj -> g.apply((S3DeliveryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String suffixPath;
        private Boolean enableHiveCompatiblePath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DeliveryConfiguration model) {
            this.suffixPath(model.suffixPath);
            this.enableHiveCompatiblePath(model.enableHiveCompatiblePath);
        }

        public final String getSuffixPath() {
            return this.suffixPath;
        }

        public final void setSuffixPath(String suffixPath) {
            this.suffixPath = suffixPath;
        }

        @Override
        public final Builder suffixPath(String suffixPath) {
            this.suffixPath = suffixPath;
            return this;
        }

        public final Boolean getEnableHiveCompatiblePath() {
            return this.enableHiveCompatiblePath;
        }

        public final void setEnableHiveCompatiblePath(Boolean enableHiveCompatiblePath) {
            this.enableHiveCompatiblePath = enableHiveCompatiblePath;
        }

        @Override
        public final Builder enableHiveCompatiblePath(Boolean enableHiveCompatiblePath) {
            this.enableHiveCompatiblePath = enableHiveCompatiblePath;
            return this;
        }

        public S3DeliveryConfiguration build() {
            return new S3DeliveryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DeliveryConfiguration> {
        public Builder suffixPath(String var1);

        public Builder enableHiveCompatiblePath(Boolean var1);
    }
}

